/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Verify;
import io.trino.spi.Page;

public class OutputSpoolingController {
    private long currentSpooledSegmentTarget;
    private final long maximumSpooledSegmentTarget;
    private final long maximumInlinedPositions;
    private final long maximumInlinedSize;
    private long spooledPositions;
    private long spooledPages;
    private long spooledRawBytes;
    private long spooledEncodedBytes;
    private long inlinedPositions;
    private long inlinedPages;
    private long inlinedRawBytes;
    private long bufferedRawSize;
    private long bufferedPositions;
    private Mode currentMode;

    public OutputSpoolingController(boolean inlineInitialRows, long maximumInlinedPositions, long maximumInlinedSize, long initialSpooledSegmentTarget, long maximumSpooledSegmentTarget) {
        this.currentSpooledSegmentTarget = initialSpooledSegmentTarget;
        this.maximumSpooledSegmentTarget = maximumSpooledSegmentTarget;
        this.maximumInlinedPositions = maximumInlinedPositions;
        this.maximumInlinedSize = maximumInlinedSize;
        this.currentMode = inlineInitialRows ? Mode.INLINE : Mode.SPOOL;
    }

    public Mode getNextMode(Page page) {
        return this.getNextMode(page.getPositionCount(), page.getSizeInBytes());
    }

    public Mode getNextMode(int positionCount, long sizeInBytes) {
        return switch (this.currentMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.inlinedPositions + (long)positionCount >= this.maximumInlinedPositions) {
                    this.currentMode = Mode.SPOOL;
                    yield this.getNextMode(positionCount, sizeInBytes);
                }
                if (this.inlinedRawBytes + sizeInBytes >= this.maximumInlinedSize) {
                    this.currentMode = Mode.SPOOL;
                    yield this.getNextMode(positionCount, sizeInBytes);
                }
                Verify.verify((this.bufferedRawSize == 0L ? 1 : 0) != 0, (String)"There should be no buffered pages when streaming", (Object[])new Object[0]);
                this.recordInlined(positionCount, sizeInBytes);
                yield Mode.INLINE;
            }
            case 2 -> {
                if (this.bufferedRawSize + sizeInBytes >= this.currentSpooledSegmentTarget) {
                    this.recordSpooled(this.bufferedPositions + (long)positionCount, this.bufferedRawSize + sizeInBytes);
                    yield Mode.SPOOL;
                }
                this.recordBuffered(positionCount, sizeInBytes);
                yield Mode.BUFFER;
            }
            case 1 -> throw new IllegalStateException("Current mode can be either STREAM or SPOOL");
        };
    }

    public void recordSpooled(long rows, long size) {
        this.bufferedRawSize = 0L;
        this.bufferedPositions = 0L;
        this.spooledPositions += rows;
        this.spooledRawBytes += size;
        ++this.spooledPages;
        this.currentSpooledSegmentTarget = Math.clamp(this.currentSpooledSegmentTarget * 2L, this.currentSpooledSegmentTarget, this.maximumSpooledSegmentTarget);
    }

    public void recordEncoded(long encodedSize) {
        this.spooledEncodedBytes += encodedSize;
    }

    public void recordInlined(int positionCount, long sizeInBytes) {
        this.inlinedPositions += (long)positionCount;
        ++this.inlinedPages;
        this.inlinedRawBytes += sizeInBytes;
    }

    public void recordBuffered(int positionCount, long sizeInBytes) {
        this.bufferedPositions += (long)positionCount;
        this.bufferedRawSize += sizeInBytes;
    }

    public long getSpooledPositions() {
        return this.spooledPositions;
    }

    public long getSpooledPages() {
        return this.spooledPages;
    }

    public long getSpooledRawBytes() {
        return this.spooledRawBytes;
    }

    public long getSpooledEncodedBytes() {
        return this.spooledEncodedBytes;
    }

    public long getInlinedPositions() {
        return this.inlinedPositions;
    }

    public long getInlinedPages() {
        return this.inlinedPages;
    }

    public long getInlinedRawBytes() {
        return this.inlinedRawBytes;
    }

    public long getBufferedRawSize() {
        return this.bufferedRawSize;
    }

    public long getBufferedPositions() {
        return this.bufferedPositions;
    }

    public long getCurrentSpooledSegmentTarget() {
        return this.currentSpooledSegmentTarget;
    }

    public static enum Mode {
        INLINE,
        BUFFER,
        SPOOL;

    }
}

