/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.metadata.Split;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorInfo;
import io.trino.operator.SourceOperator;
import io.trino.operator.SplitOperatorInfo;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorSourceOperator;
import io.trino.operator.WorkProcessorSourceOperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.metrics.Metrics;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class WorkProcessorSourceOperatorAdapter
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final WorkProcessorSourceOperator sourceOperator;
    private final WorkProcessor<Page> pages;
    private final SplitBuffer splitBuffer;
    private boolean operatorFinishing;
    private long previousPhysicalInputBytes;
    private long previousPhysicalInputPositions;
    private long previousInternalNetworkInputBytes;
    private long previousInternalNetworkPositions;
    private long previousInputBytes;
    private long previousInputPositions;
    private long previousReadTimeNanos;
    private long previousDynamicFilterSplitsProcessed;

    public WorkProcessorSourceOperatorAdapter(OperatorContext operatorContext, WorkProcessorSourceOperatorFactory sourceOperatorFactory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sourceId = sourceOperatorFactory.getSourceId();
        this.splitBuffer = new SplitBuffer();
        this.sourceOperator = sourceOperatorFactory.create(operatorContext, new MemoryTrackingContext(operatorContext.aggregateUserMemoryContext(), operatorContext.aggregateRevocableMemoryContext()), operatorContext.getDriverContext().getYieldSignal(), WorkProcessor.create(this.splitBuffer));
        this.pages = this.sourceOperator.getOutputPages().map(Page::getLoadedPage).withProcessStateMonitor(state -> this.updateOperatorStats()).finishWhen(() -> this.operatorFinishing);
        operatorContext.setInfoSupplier(() -> this.sourceOperator.getOperatorInfo().orElse(null));
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public void addSplit(Split split) {
        if (this.operatorFinishing) {
            return;
        }
        Map<String, String> splitInfo = split.getInfo();
        if (!splitInfo.isEmpty()) {
            this.operatorContext.setInfoSupplier((Supplier<? extends OperatorInfo>)Suppliers.ofInstance((Object)new SplitOperatorInfo(split.getCatalogHandle(), splitInfo)));
        }
        this.splitBuffer.add(split);
    }

    @Override
    public void noMoreSplits() {
        this.splitBuffer.noMoreSplits();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        if (!this.pages.isBlocked()) {
            return NOT_BLOCKED;
        }
        return this.pages.getBlockedFuture();
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        if (!this.pages.process()) {
            return null;
        }
        if (this.pages.isFinished()) {
            return null;
        }
        return this.pages.getResult();
    }

    @Override
    public void finish() {
        this.operatorFinishing = true;
        this.noMoreSplits();
    }

    @Override
    public boolean isFinished() {
        return this.pages.isFinished();
    }

    @Override
    public void close() throws Exception {
        this.sourceOperator.close();
        this.operatorContext.setLatestMetrics(this.sourceOperator.getMetrics());
        this.operatorContext.setLatestConnectorMetrics(this.sourceOperator.getConnectorMetrics());
    }

    private void updateOperatorStats() {
        long currentPhysicalInputBytes = this.sourceOperator.getPhysicalInputDataSize().toBytes();
        long currentPhysicalInputPositions = this.sourceOperator.getPhysicalInputPositions();
        long currentReadTimeNanos = this.sourceOperator.getReadTime().roundTo(TimeUnit.NANOSECONDS);
        long currentInternalNetworkInputBytes = this.sourceOperator.getInternalNetworkInputDataSize().toBytes();
        long currentInternalNetworkPositions = this.sourceOperator.getInternalNetworkPositions();
        long currentInputBytes = this.sourceOperator.getInputDataSize().toBytes();
        long currentInputPositions = this.sourceOperator.getInputPositions();
        long currentDynamicFilterSplitsProcessed = this.sourceOperator.getDynamicFilterSplitsProcessed();
        Metrics currentMetrics = this.sourceOperator.getMetrics();
        Metrics currentConnectorMetrics = this.sourceOperator.getConnectorMetrics();
        if (currentPhysicalInputBytes != this.previousPhysicalInputBytes || currentPhysicalInputPositions != this.previousPhysicalInputPositions || currentReadTimeNanos != this.previousReadTimeNanos) {
            this.operatorContext.recordPhysicalInputWithTiming(currentPhysicalInputBytes - this.previousPhysicalInputBytes, currentPhysicalInputPositions - this.previousPhysicalInputPositions, currentReadTimeNanos - this.previousReadTimeNanos);
            this.previousPhysicalInputBytes = currentPhysicalInputBytes;
            this.previousPhysicalInputPositions = currentPhysicalInputPositions;
            this.previousReadTimeNanos = currentReadTimeNanos;
        }
        if (currentInternalNetworkInputBytes != this.previousInternalNetworkInputBytes || currentInternalNetworkPositions != this.previousInternalNetworkPositions) {
            this.operatorContext.recordNetworkInput(currentInternalNetworkInputBytes - this.previousInternalNetworkInputBytes, currentInternalNetworkPositions - this.previousInternalNetworkPositions);
            this.previousInternalNetworkInputBytes = currentInternalNetworkInputBytes;
            this.previousInternalNetworkPositions = currentInternalNetworkPositions;
        }
        if (currentInputBytes != this.previousInputBytes || currentInputPositions != this.previousInputPositions) {
            this.operatorContext.recordProcessedInput(currentInputBytes - this.previousInputBytes, currentInputPositions - this.previousInputPositions);
            this.previousInputBytes = currentInputBytes;
            this.previousInputPositions = currentInputPositions;
        }
        if (currentDynamicFilterSplitsProcessed != this.previousDynamicFilterSplitsProcessed) {
            this.operatorContext.recordDynamicFilterSplitProcessed(currentDynamicFilterSplitsProcessed - this.previousDynamicFilterSplitsProcessed);
            this.previousDynamicFilterSplitsProcessed = currentDynamicFilterSplitsProcessed;
        }
        this.operatorContext.setLatestMetrics(currentMetrics);
        this.operatorContext.setLatestConnectorMetrics(currentConnectorMetrics);
    }

    private static class SplitBuffer
    implements WorkProcessor.Process<Split> {
        private final Deque<Split> pendingSplits = new ArrayDeque<Split>();
        private SettableFuture<Void> blockedOnSplits = SettableFuture.create();
        private boolean noMoreSplits;

        private SplitBuffer() {
        }

        @Override
        public WorkProcessor.ProcessState<Split> process() {
            if (this.pendingSplits.isEmpty()) {
                if (this.noMoreSplits) {
                    return WorkProcessor.ProcessState.finished();
                }
                this.blockedOnSplits = SettableFuture.create();
                return WorkProcessor.ProcessState.blocked(this.blockedOnSplits);
            }
            return WorkProcessor.ProcessState.ofResult(this.pendingSplits.remove());
        }

        void add(Split split) {
            this.pendingSplits.add(split);
            this.blockedOnSplits.set(null);
        }

        void noMoreSplits() {
            this.noMoreSplits = true;
            this.blockedOnSplits.set(null);
        }
    }
}

