/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.arrayagg;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.operator.aggregation.arrayagg.ArrayAggregationState;
import io.trino.operator.aggregation.arrayagg.FlatArrayBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;

public class SingleArrayAggregationState
implements ArrayAggregationState {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleArrayAggregationState.class);
    private final FlatArrayBuilder arrayBuilder;
    private Block tempDeserializeBlock;

    public SingleArrayAggregationState(Type type, MethodHandle readFlat, MethodHandle writeFlat) {
        this.arrayBuilder = new FlatArrayBuilder(type, readFlat, writeFlat, false);
    }

    private SingleArrayAggregationState(SingleArrayAggregationState state) {
        Preconditions.checkArgument((state.tempDeserializeBlock == null ? 1 : 0) != 0);
        this.arrayBuilder = state.arrayBuilder.copy();
        this.tempDeserializeBlock = null;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.arrayBuilder.getEstimatedSize();
    }

    @Override
    public void add(ValueBlock block, int position) {
        this.arrayBuilder.add(block, position);
    }

    @Override
    public void writeAll(BlockBuilder blockBuilder) {
        this.arrayBuilder.writeAll(blockBuilder);
    }

    @Override
    public boolean isEmpty() {
        return this.arrayBuilder.size() == 0L;
    }

    public ArrayAggregationState copy() {
        return new SingleArrayAggregationState(this);
    }

    Block removeTempDeserializeBlock() {
        Block block = this.tempDeserializeBlock;
        Preconditions.checkState((block != null ? 1 : 0) != 0, (Object)"tempDeserializeBlock is null");
        this.tempDeserializeBlock = null;
        return block;
    }

    void setTempDeserializeBlock(Block tempDeserializeBlock) {
        this.tempDeserializeBlock = tempDeserializeBlock;
    }
}

