/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.GenericSliceState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import java.util.Objects;

public class GenericSliceStateSerializer
implements AccumulatorStateSerializer<GenericSliceState> {
    private final Type serializedType;

    public GenericSliceStateSerializer(Type serializedType) {
        this.serializedType = Objects.requireNonNull(serializedType, "serializedType is null");
    }

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(GenericSliceState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            this.serializedType.writeSlice(out, state.getValue());
        }
    }

    public void deserialize(Block block, int index, GenericSliceState state) {
        state.setNull(false);
        state.setValue(this.serializedType.getSlice(block, index));
    }
}

