/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.exchange;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.trino.operator.exchange.LocalExchangeMemoryManager;
import io.trino.operator.exchange.LocalExchanger;
import io.trino.spi.Page;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ScaleWriterExchanger
implements LocalExchanger {
    private static final Logger log = Logger.get(ScaleWriterExchanger.class);
    private final List<Consumer<Page>> buffers;
    private final LocalExchangeMemoryManager memoryManager;
    private final long maxBufferedBytes;
    private final AtomicLong dataProcessed;
    private final long writerScalingMinDataProcessed;
    private final Supplier<Long> totalMemoryUsed;
    private final long maxMemoryPerNode;
    private int writerCount = 1;
    private int nextWriterIndex = -1;

    public ScaleWriterExchanger(List<Consumer<Page>> buffers, LocalExchangeMemoryManager memoryManager, long maxBufferedBytes, AtomicLong dataProcessed, DataSize writerScalingMinDataProcessed, Supplier<Long> totalMemoryUsed, long maxMemoryPerNode) {
        this.buffers = Objects.requireNonNull(buffers, "buffers is null");
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.maxBufferedBytes = maxBufferedBytes;
        this.dataProcessed = Objects.requireNonNull(dataProcessed, "dataProcessed is null");
        this.writerScalingMinDataProcessed = writerScalingMinDataProcessed.toBytes();
        this.totalMemoryUsed = Objects.requireNonNull(totalMemoryUsed, "totalMemoryUsed is null");
        this.maxMemoryPerNode = maxMemoryPerNode;
    }

    @Override
    public void accept(Page page) {
        this.dataProcessed.addAndGet(page.getSizeInBytes());
        Consumer<Page> buffer = this.buffers.get(this.getNextWriterIndex());
        this.memoryManager.updateMemoryUsage(page.getRetainedSizeInBytes());
        buffer.accept(page);
    }

    private int getNextWriterIndex() {
        if (this.writerCount < this.buffers.size() && this.memoryManager.getBufferedBytes() >= this.maxBufferedBytes / 2L && this.dataProcessed.get() >= (long)this.writerCount * this.writerScalingMinDataProcessed && (double)this.totalMemoryUsed.get().longValue() < (double)this.maxMemoryPerNode * 0.5) {
            ++this.writerCount;
            log.debug("Increased task writer count: %d", new Object[]{this.writerCount});
        }
        this.nextWriterIndex = (this.nextWriterIndex + 1) % this.writerCount;
        return this.nextWriterIndex;
    }

    @Override
    public ListenableFuture<Void> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

