/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.operator.HashGenerator;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.operator.JoinOperatorType;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PrecomputedHashGenerator;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.WorkProcessorOperatorFactory;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.JoinOperatorFactory;
import io.trino.operator.join.JoinProbe;
import io.trino.operator.join.LookupJoinOperator;
import io.trino.operator.join.LookupOuterOperator;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class LookupJoinOperatorFactory
implements JoinOperatorFactory,
WorkProcessorOperatorFactory {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final List<Type> probeTypes;
    private final List<Type> buildOutputTypes;
    private final JoinType joinType;
    private final boolean outputSingleMatch;
    private final boolean waitForBuild;
    private final JoinProbe.JoinProbeFactory joinProbeFactory;
    private final Optional<OperatorFactory> outerOperatorFactory;
    private final JoinBridgeManager<? extends LookupSourceFactory> joinBridgeManager;
    private final OptionalInt totalOperatorsCount;
    private final HashGenerator probeHashGenerator;
    private final PartitioningSpillerFactory partitioningSpillerFactory;
    private boolean closed;

    public LookupJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactoryManager, List<Type> probeTypes, List<Type> probeOutputTypes, List<Type> buildOutputTypes, JoinOperatorType joinOperatorType, JoinProbe.JoinProbeFactory joinProbeFactory, TypeOperators typeOperators, OptionalInt totalOperatorsCount, List<Integer> probeJoinChannels, OptionalInt probeHashChannel, PartitioningSpillerFactory partitioningSpillerFactory) {
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.probeTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeTypes, "probeTypes is null"));
        this.buildOutputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null"));
        this.joinType = Objects.requireNonNull(joinOperatorType.getType(), "joinType is null");
        this.outputSingleMatch = joinOperatorType.isOutputSingleMatch();
        this.waitForBuild = joinOperatorType.isWaitForBuild();
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.joinBridgeManager = lookupSourceFactoryManager;
        this.joinBridgeManager.incrementProbeFactoryCount();
        this.outerOperatorFactory = this.joinType == JoinType.INNER || this.joinType == JoinType.PROBE_OUTER ? Optional.empty() : Optional.of(new LookupOuterOperator.LookupOuterOperatorFactory(operatorId, planNodeId, probeOutputTypes, buildOutputTypes, lookupSourceFactoryManager));
        this.totalOperatorsCount = Objects.requireNonNull(totalOperatorsCount, "totalOperatorsCount is null");
        Objects.requireNonNull(probeHashChannel, "probeHashChannel is null");
        if (probeHashChannel.isPresent()) {
            this.probeHashGenerator = new PrecomputedHashGenerator(probeHashChannel.getAsInt());
        } else {
            Objects.requireNonNull(probeJoinChannels, "probeJoinChannels is null");
            List hashTypes = (List)probeJoinChannels.stream().map(probeTypes::get).collect(ImmutableList.toImmutableList());
            this.probeHashGenerator = InterpretedHashGenerator.createChannelsHashGenerator(hashTypes, Ints.toArray(probeJoinChannels), typeOperators);
        }
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
    }

    private LookupJoinOperatorFactory(LookupJoinOperatorFactory other) {
        Objects.requireNonNull(other, "other is null");
        Preconditions.checkArgument((!other.closed ? 1 : 0) != 0, (Object)"cannot duplicated closed OperatorFactory");
        this.operatorId = other.operatorId;
        this.planNodeId = other.planNodeId;
        this.probeTypes = other.probeTypes;
        this.buildOutputTypes = other.buildOutputTypes;
        this.joinType = other.joinType;
        this.outputSingleMatch = other.outputSingleMatch;
        this.waitForBuild = other.waitForBuild;
        this.joinProbeFactory = other.joinProbeFactory;
        this.outerOperatorFactory = other.outerOperatorFactory;
        this.joinBridgeManager = other.joinBridgeManager;
        this.totalOperatorsCount = other.totalOperatorsCount;
        this.probeHashGenerator = other.probeHashGenerator;
        this.partitioningSpillerFactory = other.partitioningSpillerFactory;
        this.closed = false;
        this.joinBridgeManager.incrementProbeFactoryCount();
    }

    @Override
    public Optional<OperatorFactory> createOuterOperatorFactory() {
        return this.outerOperatorFactory;
    }

    @Override
    public int getOperatorId() {
        return this.operatorId;
    }

    @Override
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @Override
    public String getOperatorType() {
        return LookupJoinOperator.class.getSimpleName();
    }

    @Override
    public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        LookupSourceFactory lookupSourceFactory = this.joinBridgeManager.getJoinBridge();
        this.joinBridgeManager.probeOperatorCreated();
        return new LookupJoinOperator(this.probeTypes, this.buildOutputTypes, this.joinType, this.outputSingleMatch, this.waitForBuild, lookupSourceFactory, this.joinProbeFactory, this.joinBridgeManager::probeOperatorClosed, this.totalOperatorsCount, this.probeHashGenerator, this.partitioningSpillerFactory, processorContext, sourcePages);
    }

    @Override
    public void close() {
        this.joinBridgeManager.probeOperatorFactoryClosed();
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closed = true;
    }

    @Override
    public LookupJoinOperatorFactory duplicate() {
        return new LookupJoinOperatorFactory(this);
    }

    public static enum JoinType {
        INNER,
        PROBE_OUTER,
        LOOKUP_OUTER,
        FULL_OUTER;

    }
}

