/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;

class TypedPositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TypedPositionsAppender.class);
    private BlockBuilder blockBuilder;

    TypedPositionsAppender(Type type, int expectedPositions) {
        this.blockBuilder = type.createBlockBuilder(null, expectedPositions);
    }

    public TypedPositionsAppender(BlockBuilder blockBuilder) {
        this.blockBuilder = blockBuilder;
    }

    @Override
    public void append(IntArrayList positions, ValueBlock block) {
        this.blockBuilder.appendPositions(block, positions.elements(), 0, positions.size());
    }

    @Override
    public void appendRle(ValueBlock block, int count) {
        this.blockBuilder.appendRepeated(block, 0, count);
    }

    @Override
    public void append(int position, ValueBlock block) {
        this.blockBuilder.append(block, position);
    }

    @Override
    public Block build() {
        Block result = this.blockBuilder.build();
        this.reset();
        return result;
    }

    @Override
    public void reset() {
        if (this.blockBuilder.getPositionCount() > 0) {
            this.blockBuilder = this.blockBuilder.newBlockBuilderLike(null);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.blockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public long getSizeInBytes() {
        return this.blockBuilder.getSizeInBytes();
    }
}

