/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderSizeAccumulator;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;

public class UnnestingPositionsAppender {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(UnnestingPositionsAppender.class);
    private final PositionsAppender delegate;
    @Nullable
    private final BlockTypeOperators.BlockPositionIsIdentical identicalOperator;
    private State state = State.UNINITIALIZED;
    @Nullable
    private ValueBlock dictionary;
    private DictionaryIdsBuilder dictionaryIdsBuilder;
    @Nullable
    private ValueBlock rleValue;
    private int rlePositionCount;

    public UnnestingPositionsAppender(PositionsAppender delegate, Optional<BlockTypeOperators.BlockPositionIsIdentical> identicalOperator) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.dictionaryIdsBuilder = new DictionaryIdsBuilder(1024);
        this.identicalOperator = identicalOperator.orElse(null);
    }

    public void append(IntArrayList positions, Block source) {
        if (positions.isEmpty()) {
            return;
        }
        Block block = source;
        Objects.requireNonNull(block);
        Block block2 = block;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RunLengthEncodedBlock.class, DictionaryBlock.class, ValueBlock.class, LazyBlock.class}, (Block)block2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block2;
                this.appendRle(rleBlock.getValue(), positions.size());
                break;
            }
            case 1: {
                DictionaryBlock dictionaryBlock = (DictionaryBlock)block2;
                ValueBlock dictionary = dictionaryBlock.getDictionary();
                if (this.state == State.UNINITIALIZED) {
                    this.state = State.DICTIONARY;
                    this.dictionary = dictionary;
                    this.dictionaryIdsBuilder.appendPositions(positions, dictionaryBlock);
                    break;
                }
                if (this.state == State.DICTIONARY && this.dictionary == dictionary) {
                    this.dictionaryIdsBuilder.appendPositions(positions, dictionaryBlock);
                    break;
                }
                this.transitionToDirect();
                int[] positionArray = new int[positions.size()];
                for (int i = 0; i < positions.size(); ++i) {
                    positionArray[i] = dictionaryBlock.getId(positions.getInt(i));
                }
                this.delegate.append(IntArrayList.wrap((int[])positionArray), dictionary);
                break;
            }
            case 2: {
                ValueBlock valueBlock = (ValueBlock)block2;
                this.transitionToDirect();
                this.delegate.append(positions, valueBlock);
                break;
            }
            case 3: {
                LazyBlock ignore = (LazyBlock)block2;
                throw new IllegalArgumentException("Unsupported block type: " + source.getClass().getSimpleName());
            }
        }
    }

    public void appendRle(ValueBlock value, int positionCount) {
        if (positionCount == 0) {
            return;
        }
        if (this.state == State.DICTIONARY) {
            this.transitionToDirect();
        }
        if (this.identicalOperator == null) {
            this.transitionToDirect();
        }
        if (this.state == State.UNINITIALIZED) {
            this.state = State.RLE;
            this.rleValue = value;
            this.rlePositionCount = positionCount;
            return;
        }
        if (this.state == State.RLE) {
            if (this.identicalOperator.isIdentical((Block)this.rleValue, 0, (Block)value, 0)) {
                this.rlePositionCount += positionCount;
                return;
            }
            this.transitionToDirect();
        }
        Verify.verify((this.state == State.DIRECT ? 1 : 0) != 0);
        this.delegate.appendRle(value, positionCount);
    }

    public void append(int position, Block source) {
        if (this.state != State.DIRECT) {
            this.transitionToDirect();
        }
        Block block = source;
        Objects.requireNonNull(block);
        Block block2 = block;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RunLengthEncodedBlock.class, DictionaryBlock.class, ValueBlock.class, LazyBlock.class}, (Block)block2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block2;
                this.delegate.append(0, runLengthEncodedBlock.getValue());
                break;
            }
            case 1: {
                DictionaryBlock dictionaryBlock = (DictionaryBlock)block2;
                this.delegate.append(dictionaryBlock.getId(position), dictionaryBlock.getDictionary());
                break;
            }
            case 2: {
                ValueBlock valueBlock = (ValueBlock)block2;
                this.delegate.append(position, valueBlock);
                break;
            }
            case 3: {
                LazyBlock ignore = (LazyBlock)block2;
                throw new IllegalArgumentException("Unsupported block type: " + source.getClass().getSimpleName());
            }
        }
    }

    private void transitionToDirect() {
        if (this.state == State.DICTIONARY) {
            int[] dictionaryIds = this.dictionaryIdsBuilder.getDictionaryIds();
            this.delegate.append(IntArrayList.wrap((int[])dictionaryIds, (int)this.dictionaryIdsBuilder.size()), this.dictionary);
            this.dictionary = null;
            this.dictionaryIdsBuilder = this.dictionaryIdsBuilder.newBuilderLike();
        } else if (this.state == State.RLE) {
            this.delegate.appendRle(this.rleValue, this.rlePositionCount);
            this.rleValue = null;
            this.rlePositionCount = 0;
        }
        this.state = State.DIRECT;
    }

    public Block build() {
        Block result = switch (this.state.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> DictionaryBlock.create((int)this.dictionaryIdsBuilder.size(), (Block)this.dictionary, (int[])this.dictionaryIdsBuilder.getDictionaryIds());
            case 2 -> RunLengthEncodedBlock.create((Block)this.rleValue, (int)this.rlePositionCount);
            case 0, 3 -> this.delegate.build();
        };
        this.reset();
        return result;
    }

    public void reset() {
        this.state = State.UNINITIALIZED;
        this.dictionary = null;
        this.dictionaryIdsBuilder = this.dictionaryIdsBuilder.newBuilderLike();
        this.rleValue = null;
        this.rlePositionCount = 0;
        this.delegate.reset();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.delegate.getRetainedSizeInBytes() + this.dictionaryIdsBuilder.getRetainedSizeInBytes() + (this.rleValue != null ? this.rleValue.getRetainedSizeInBytes() : 0L);
    }

    public long getSizeInBytes() {
        return this.delegate.getSizeInBytes() + (long)this.dictionaryIdsBuilder.size() * 4L + (this.rleValue != null ? this.rleValue.getSizeInBytes() : 0L);
    }

    void addSizesToAccumulator(PositionsAppenderSizeAccumulator accumulator) {
        long sizeInBytes = this.getSizeInBytes();
        long directSizeInBytes = this.rleValue == null ? sizeInBytes : this.rleValue.getSizeInBytes() * (long)this.rlePositionCount;
        accumulator.accumulate(sizeInBytes, directSizeInBytes);
    }

    public void flattenPendingDictionary() {
        if (this.state == State.DICTIONARY && this.dictionary != null) {
            this.transitionToDirect();
        }
    }

    public boolean shouldForceFlushBeforeRelease() {
        if (this.state == State.DICTIONARY && this.dictionary != null) {
            IntOpenHashSet uniqueIdsSet = new IntOpenHashSet();
            int[] dictionaryIds = this.dictionaryIdsBuilder.getDictionaryIds();
            for (int i = 0; i < this.dictionaryIdsBuilder.size(); ++i) {
                if (uniqueIdsSet.add(dictionaryIds[i])) continue;
                return true;
            }
        }
        return false;
    }

    private static enum State {
        UNINITIALIZED,
        DICTIONARY,
        RLE,
        DIRECT;

    }

    private static class DictionaryIdsBuilder {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(DictionaryIdsBuilder.class);
        private final int initialEntryCount;
        private int[] dictionaryIds;
        private int size;

        public DictionaryIdsBuilder(int initialEntryCount) {
            this.initialEntryCount = initialEntryCount;
            this.dictionaryIds = new int[0];
        }

        public int[] getDictionaryIds() {
            return this.dictionaryIds;
        }

        public int size() {
            return this.size;
        }

        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.dictionaryIds);
        }

        public void appendPositions(IntArrayList positions, DictionaryBlock block) {
            Preconditions.checkArgument((!positions.isEmpty() ? 1 : 0) != 0, (Object)"positions is empty");
            this.ensureCapacity(this.size + positions.size());
            for (int i = 0; i < positions.size(); ++i) {
                this.dictionaryIds[this.size + i] = block.getId(positions.getInt(i));
            }
            this.size += positions.size();
        }

        public DictionaryIdsBuilder newBuilderLike() {
            if (this.size == 0) {
                return this;
            }
            return new DictionaryIdsBuilder(Math.max(PositionsAppenderUtil.calculateBlockResetSize(this.size), this.initialEntryCount));
        }

        private void ensureCapacity(int capacity) {
            if (this.dictionaryIds.length >= capacity) {
                return;
            }
            int newSize = this.dictionaryIds.length > 0 ? PositionsAppenderUtil.calculateNewArraySize(this.dictionaryIds.length) : this.initialEntryCount;
            newSize = Math.max(newSize, capacity);
            this.dictionaryIds = IntArrays.ensureCapacity((int[])this.dictionaryIds, (int)newSize, (int)this.size);
        }
    }
}

