/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import io.trino.operator.project.InputChannels;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;

public interface PageFilter {
    public boolean isDeterministic();

    public InputChannels getInputChannels();

    public SelectedPositions filter(ConnectorSession var1, Page var2);

    public static SelectedPositions positionsArrayToSelectedPositions(boolean[] selectedPositions, int size) {
        int selectedCount = 0;
        for (int i = 0; i < size; ++i) {
            boolean selectedPosition = selectedPositions[i];
            selectedCount += selectedPosition ? 1 : 0;
        }
        if (selectedCount == 0 || selectedCount == size) {
            return SelectedPositions.positionsRange(0, selectedCount);
        }
        int[] positions = new int[selectedCount];
        int index = 0;
        int position = 0;
        while (index < selectedCount) {
            positions[index] = position;
            index += selectedPositions[position] ? 1 : 0;
            ++position;
        }
        return SelectedPositions.positionsList(positions, 0, selectedCount);
    }
}

