/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Iterator;

@ScalarFunction(value="array_remove")
@Description(value="Remove specified values from the given array")
public final class ArrayRemoveFunction {
    private final BufferedArrayValueBuilder arrayValueBuilder;

    @TypeParameter(value="E")
    public ArrayRemoveFunction(@TypeParameter(value="E") Type elementType) {
        this.arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)new ArrayType(elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block remove(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") Object value) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < array.getPositionCount(); ++i) {
            Object element = TypeUtils.readNativeValue((Type)type, (Block)array, (int)i);
            try {
                if (element == null) {
                    positions.add(i);
                    continue;
                }
                Boolean result = equalFunction.invoke(element, value);
                if (result == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "array_remove does not support arrays with elements that are null or contain null");
                }
                if (result.booleanValue()) continue;
                positions.add(i);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (array.getPositionCount() == positions.size()) {
            return array;
        }
        return this.arrayValueBuilder.build(positions.size(), elementBuilder -> {
            Iterator iterator = positions.iterator();
            while (iterator.hasNext()) {
                int position = (Integer)iterator.next();
                type.appendTo(array, position, elementBuilder);
            }
        });
    }
}

