/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.block.Block;
import io.trino.spi.block.BufferedArrayValueBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import java.util.concurrent.ThreadLocalRandom;

@ScalarFunction(value="shuffle", deterministic=false)
@Description(value="Generates a random permutation of the given array.")
public final class ArrayShuffleFunction {
    private final BufferedArrayValueBuilder arrayValueBuilder;
    private static final int INITIAL_LENGTH = 128;
    private int[] positions = new int[128];

    @TypeParameter(value="E")
    public ArrayShuffleFunction(@TypeParameter(value="E") Type elementType) {
        this.arrayValueBuilder = BufferedArrayValueBuilder.createBuffered((ArrayType)new ArrayType(elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block shuffle(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block block) {
        int i;
        int length = block.getPositionCount();
        if (this.positions.length < length) {
            this.positions = new int[length];
        }
        for (i = 0; i < length; ++i) {
            this.positions[i] = i;
        }
        for (i = length - 1; i > 0; --i) {
            int index = ThreadLocalRandom.current().nextInt(i + 1);
            int swap = this.positions[i];
            this.positions[i] = this.positions[index];
            this.positions[index] = swap;
        }
        return this.arrayValueBuilder.build(length, elementBuilder -> {
            for (int i = 0; i < length; ++i) {
                type.appendTo(block, this.positions[i], elementBuilder);
            }
        });
    }
}

