/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.Signature;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;

public final class ConcatFunction
extends SqlScalarFunction {
    public static final ConcatFunction VARCHAR_CONCAT = new ConcatFunction(VarcharType.VARCHAR.getTypeSignature(), "Concatenates given strings");
    public static final ConcatFunction VARBINARY_CONCAT = new ConcatFunction(VarbinaryType.VARBINARY.getTypeSignature(), "concatenates given varbinary values");
    private static final int MAX_OUTPUT_LENGTH = 0x100000;

    private ConcatFunction(TypeSignature type, String description) {
        super(FunctionMetadata.scalarBuilder((String)"concat").signature(Signature.builder().returnType(type).argumentType(type).variableArity().build()).description(description).build());
    }

    @Override
    protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
        int arity = boundSignature.getArity();
        if (arity < 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more concatenation arguments");
        }
        MethodHandle arrayMethodHandle = Reflection.methodHandle(ConcatFunction.class, "concat", Slice[].class);
        MethodHandle customMethodHandle = arrayMethodHandle.asCollector(Slice[].class, arity);
        return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(arity, InvocationConvention.InvocationArgumentConvention.NEVER_NULL), customMethodHandle);
    }

    public static Slice concat(Slice[] values) {
        int length = 0;
        for (Slice value : values) {
            if ((length = Math.addExact(length, value.length())) <= 0x100000) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Concatenated string is too large");
        }
        Slice result = Slices.allocate((int)length);
        int position = 0;
        for (Slice value : values) {
            result.setBytes(position, value);
            position += value.length();
        }
        return result;
    }
}

