/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import io.airlift.slice.SizeOf;
import io.trino.operator.unnest.UnnestBlockBuilder;
import io.trino.operator.unnest.UnnestOperator;
import io.trino.operator.unnest.Unnester;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.RowBlock;
import java.util.List;
import java.util.Objects;

public class ArrayOfRowsUnnester
implements Unnester {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ArrayOfRowsUnnester.class);
    private final UnnestBlockBuilder[] blockBuilders;
    private int[] arrayLengths = new int[0];
    private ColumnarArray columnarArray;

    public ArrayOfRowsUnnester(int fieldCount) {
        this.blockBuilders = new UnnestBlockBuilder[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            this.blockBuilders[i] = new UnnestBlockBuilder();
        }
    }

    @Override
    public int getChannelCount() {
        return this.blockBuilders.length;
    }

    @Override
    public void resetInput(Block block) {
        Objects.requireNonNull(block, "block is null");
        this.columnarArray = ColumnarArray.toColumnarArray((Block)block);
        List fields = RowBlock.getRowFieldsFromBlock((Block)this.columnarArray.getElementsBlock());
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i].resetInputBlock((Block)fields.get(i));
        }
        int positionCount = block.getPositionCount();
        this.arrayLengths = UnnestOperator.ensureCapacity(this.arrayLengths, positionCount, false);
        for (int i = 0; i < positionCount; ++i) {
            this.arrayLengths[i] = this.columnarArray.getLength(i);
        }
    }

    @Override
    public int[] getOutputEntriesPerPosition() {
        return this.arrayLengths;
    }

    @Override
    public Block[] buildOutputBlocks(int[] outputEntriesPerPosition, int startPosition, int inputBatchSize, int outputRowCount) {
        int unnestLength = this.columnarArray.getOffset(startPosition + inputBatchSize) - this.columnarArray.getOffset(startPosition);
        boolean nullRequired = unnestLength < outputRowCount;
        Block[] outputBlocks = new Block[this.blockBuilders.length];
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            outputBlocks[i] = nullRequired ? this.blockBuilders[i].buildWithNulls(outputEntriesPerPosition, startPosition, inputBatchSize, outputRowCount, this.arrayLengths) : this.blockBuilders[i].buildWithoutNulls(outputRowCount);
        }
        return outputBlocks;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.arrayLengths);
    }
}

