/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import io.airlift.slice.SizeOf;
import io.trino.operator.unnest.UnnestBlockBuilder;
import io.trino.operator.unnest.UnnestOperator;
import io.trino.operator.unnest.Unnester;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarMap;
import java.util.Objects;

public class MapUnnester
implements Unnester {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MapUnnester.class);
    private final UnnestBlockBuilder keyBlockBuilder;
    private final UnnestBlockBuilder valueBlockBuilder;
    int[] mapLengths = new int[0];
    private ColumnarMap columnarMap;

    public MapUnnester() {
        this.keyBlockBuilder = new UnnestBlockBuilder();
        this.valueBlockBuilder = new UnnestBlockBuilder();
    }

    @Override
    public int getChannelCount() {
        return 2;
    }

    @Override
    public void resetInput(Block block) {
        Objects.requireNonNull(block, "block is null");
        this.columnarMap = ColumnarMap.toColumnarMap((Block)block);
        this.keyBlockBuilder.resetInputBlock(this.columnarMap.getKeysBlock());
        this.valueBlockBuilder.resetInputBlock(this.columnarMap.getValuesBlock());
        int positionCount = block.getPositionCount();
        this.mapLengths = UnnestOperator.ensureCapacity(this.mapLengths, positionCount, false);
        for (int i = 0; i < positionCount; ++i) {
            this.mapLengths[i] = this.columnarMap.getEntryCount(i);
        }
    }

    @Override
    public int[] getOutputEntriesPerPosition() {
        return this.mapLengths;
    }

    @Override
    public Block[] buildOutputBlocks(int[] outputEntriesPerPosition, int startPosition, int inputBatchSize, int outputRowCount) {
        boolean nullRequired = this.needToInsertNulls(startPosition, inputBatchSize, outputRowCount);
        Block[] outputBlocks = new Block[2];
        if (nullRequired) {
            outputBlocks[0] = this.keyBlockBuilder.buildWithNulls(outputEntriesPerPosition, startPosition, inputBatchSize, outputRowCount, this.mapLengths);
            outputBlocks[1] = this.valueBlockBuilder.buildWithNulls(outputEntriesPerPosition, startPosition, inputBatchSize, outputRowCount, this.mapLengths);
        } else {
            outputBlocks[0] = this.keyBlockBuilder.buildWithoutNulls(outputRowCount);
            outputBlocks[1] = this.valueBlockBuilder.buildWithoutNulls(outputRowCount);
        }
        return outputBlocks;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.mapLengths);
    }

    private boolean needToInsertNulls(int offset, int length, int outputRowCount) {
        int unnestedMapEntries = this.columnarMap.getOffset(offset + length) - this.columnarMap.getOffset(offset);
        return unnestedMapEntries < outputRowCount;
    }
}

