/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Inject;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.trino.server.ForAsyncHttp;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class AsyncHttpExecutionMBean {
    private final ThreadPoolExecutorMBean responseExecutor;
    private final ThreadPoolExecutorMBean timeoutExecutor;

    @Inject
    public AsyncHttpExecutionMBean(@ForAsyncHttp ExecutorService responseExecutor, @ForAsyncHttp ScheduledExecutorService timeoutExecutor) {
        Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
        this.responseExecutor = new ThreadPoolExecutorMBean((ThreadPoolExecutor)responseExecutor);
        this.timeoutExecutor = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)timeoutExecutor));
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getResponseExecutor() {
        return this.responseExecutor;
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getTimeoutExecutor() {
        return this.timeoutExecutor;
    }
}

