/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.net.MediaType;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.util.Collection;
import java.util.Optional;

public final class ServletSecurityUtils {
    private static final String AUTHENTICATED_IDENTITY = "trino.authenticated-identity";

    private ServletSecurityUtils() {
    }

    public static void sendErrorMessage(ContainerRequestContext request, Response.Status errorCode, String errorMessage) {
        request.abortWith(ServletSecurityUtils.errorResponse(errorCode, errorMessage).build());
    }

    public static void sendWwwAuthenticate(ContainerRequestContext request, String errorMessage, Collection<String> authenticateHeaders) {
        request.abortWith(ServletSecurityUtils.authenticateResponse(errorMessage, authenticateHeaders).build());
    }

    private static Response.ResponseBuilder authenticateResponse(String errorMessage, Collection<String> authenticateHeaders) {
        Response.ResponseBuilder response = ServletSecurityUtils.errorResponse(Response.Status.UNAUTHORIZED, errorMessage);
        for (String value : authenticateHeaders) {
            response.header("WWW-Authenticate", (Object)value);
        }
        return response;
    }

    private static Response.ResponseBuilder errorResponse(Response.Status errorCode, String errorMessage) {
        return Response.status((int)errorCode.getStatusCode(), (String)errorMessage).type(MediaType.PLAIN_TEXT_UTF_8.toString()).entity((Object)errorMessage);
    }

    public static Optional<Identity> authenticatedIdentity(ContainerRequestContext request) {
        return Optional.ofNullable((Identity)request.getProperty(AUTHENTICATED_IDENTITY));
    }

    public static Optional<Identity> authenticatedIdentity(HttpServletRequest request) {
        return Optional.ofNullable((Identity)request.getAttribute(AUTHENTICATED_IDENTITY));
    }

    public static void clearAuthenticatedIdentity(HttpServletRequest request) {
        request.setAttribute(AUTHENTICATED_IDENTITY, null);
    }

    public static void setAuthenticatedIdentity(ContainerRequestContext request, String username) {
        ServletSecurityUtils.setAuthenticatedIdentity(request, Identity.forUser((String)username).withPrincipal((Principal)new BasicPrincipal(username)).build());
    }

    public static void setAuthenticatedIdentity(ContainerRequestContext request, Identity authenticatedIdentity) {
        request.setProperty(AUTHENTICATED_IDENTITY, (Object)authenticatedIdentity);
        final boolean secure = request.getSecurityContext().isSecure();
        final Principal principal = authenticatedIdentity.getPrincipal().orElse(null);
        request.setSecurityContext(new SecurityContext(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return secure;
            }

            public String getAuthenticationScheme() {
                return "trino";
            }
        });
    }
}

