/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.client.ClientCapabilities;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.QueryResultRows;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class JsonArrayResultsIterator
extends AbstractIterator<List<Object>>
implements Iterable<List<Object>> {
    private final Deque<Page> queue;
    private final Session session;
    private final ImmutableList<Page> pages;
    private final List<OutputColumn> columns;
    private final boolean supportsParametricDateTime;
    private final Consumer<TrinoException> exceptionConsumer;
    private Page currentPage;
    private int rowPosition = -1;
    private int inPageIndex = -1;

    public JsonArrayResultsIterator(Session session, List<Page> pages, List<OutputColumn> columns, Consumer<TrinoException> exceptionConsumer) {
        this.pages = ImmutableList.copyOf(pages);
        this.queue = new ArrayDeque<Page>(pages);
        this.session = Objects.requireNonNull(session, "session is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.supportsParametricDateTime = session.getClientCapabilities().contains(ClientCapabilities.PARAMETRIC_DATETIME.toString());
        this.exceptionConsumer = Objects.requireNonNull(exceptionConsumer, "exceptionConsumer is null");
        this.currentPage = this.queue.pollFirst();
    }

    protected List<Object> computeNext() {
        List<Object> row;
        do {
            if (this.currentPage == null) {
                return (List)this.endOfData();
            }
            ++this.inPageIndex;
            if (this.inPageIndex >= this.currentPage.getPositionCount()) {
                this.currentPage = this.queue.pollFirst();
                if (this.currentPage == null) {
                    return (List)this.endOfData();
                }
                this.inPageIndex = 0;
            }
            ++this.rowPosition;
        } while ((row = this.getRowValues()) == null);
        return row;
    }

    @Nullable
    private List<Object> getRowValues() {
        ArrayList<Object> row = new ArrayList<Object>(this.columns.size());
        ConnectorSession connectorSession = this.session.toConnectorSession();
        for (OutputColumn outputColumn : this.columns) {
            Type type = outputColumn.type();
            try {
                Block block = this.currentPage.getBlock(outputColumn.sourcePageChannel());
                Object value = type.getObjectValue(connectorSession, block, this.inPageIndex);
                if (!this.supportsParametricDateTime) {
                    value = this.getLegacyValue(value, type);
                }
                row.add(value);
            }
            catch (Throwable throwable) {
                this.propagateException(this.rowPosition, outputColumn.sourcePageChannel(), outputColumn.columnName(), outputColumn.type(), throwable);
                return null;
            }
        }
        return Collections.unmodifiableList(row);
    }

    private Object getLegacyValue(Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (!this.supportsParametricDateTime) {
            if (type instanceof TimestampType) {
                return ((SqlTimestamp)value).roundTo(3);
            }
            if (type instanceof TimestampWithTimeZoneType) {
                return ((SqlTimestampWithTimeZone)value).roundTo(3);
            }
            if (type instanceof TimeType) {
                return ((SqlTime)value).roundTo(3);
            }
            if (type instanceof TimeWithTimeZoneType) {
                return ((SqlTimeWithTimeZone)value).roundTo(3);
            }
        }
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            if (!(elementType instanceof TimestampType) && !(elementType instanceof TimestampWithTimeZoneType)) {
                return value;
            }
            List listValue = (List)value;
            ArrayList<Object> legacyValues = new ArrayList<Object>(listValue.size());
            for (Object element : listValue) {
                legacyValues.add(this.getLegacyValue(element, elementType));
            }
            return Collections.unmodifiableList(legacyValues);
        }
        if (type instanceof MapType) {
            Type keyType = ((MapType)type).getKeyType();
            Type valueType = ((MapType)type).getValueType();
            Map mapValue = (Map)value;
            HashMap result = Maps.newHashMapWithExpectedSize((int)mapValue.size());
            mapValue.forEach((? super K key, ? super V val) -> result.put(this.getLegacyValue(key, keyType), this.getLegacyValue(val, valueType)));
            return Collections.unmodifiableMap(result);
        }
        if (type instanceof RowType) {
            List fields = ((RowType)type).getFields();
            List values = (List)value;
            ArrayList<Object> result = new ArrayList<Object>(values.size());
            for (int i = 0; i < values.size(); ++i) {
                result.add(this.getLegacyValue(values.get(i), ((RowType.Field)fields.get(i)).getType()));
            }
            return Collections.unmodifiableList(result);
        }
        return value;
    }

    private void propagateException(int row, int channel, String name, Type type, Throwable cause) {
        String message = String.format("Could not serialize column '%s' of type '%s' at position %d:%d", name, type, row + 1, channel + 1);
        this.exceptionConsumer.accept(new TrinoException((ErrorCodeSupplier)StandardErrorCode.SERIALIZATION_ERROR, message, cause));
    }

    @Override
    public Iterator<List<Object>> iterator() {
        return new JsonArrayResultsIterator(this.session, (List<Page>)this.pages, this.columns, this.exceptionConsumer);
    }

    public static Iterable<List<Object>> toIterableList(Session session, QueryResultRows rows, Consumer<TrinoException> serializationExceptionHandler) {
        if (rows.getOutputColumns().isEmpty()) {
            return Collections.emptyList();
        }
        List<OutputColumn> columnAndTypes = rows.getOutputColumns().orElseThrow();
        return new JsonArrayResultsIterator(session, rows.getPages(), columnAndTypes, serializationExceptionHandler);
    }
}

