/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import io.trino.server.ExternalUriInfo;
import io.trino.server.security.ResourceSecurity;
import io.trino.web.ui.WebUiResources;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;

@Path(value="")
public class WebUiStaticResource {
    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    public Response getRoot(@BeanParam ExternalUriInfo externalUriInfo) {
        return Response.seeOther((URI)externalUriInfo.absolutePath("/ui/")).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="/ui")
    public Response getUi(@BeanParam ExternalUriInfo externalUriInfo) {
        return Response.seeOther((URI)externalUriInfo.absolutePath("/ui/")).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @POST
    @Path(value="/ui/{path: .*}")
    public Response postFile() {
        throw new NotFoundException();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="/ui/assets/{path: .*}")
    public Response getAssetsFile(@PathParam(value="path") String path) throws IOException {
        return this.getFile("assets/" + path);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="/ui/vendor/{path: .*}")
    public Response getVendorFile(@PathParam(value="path") String path) throws IOException {
        return this.getFile("vendor/" + path);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    @Path(value="/ui/{path: .*}")
    public Response getFile(@PathParam(value="path") String path) throws IOException {
        if (path.isEmpty()) {
            path = "index.html";
        }
        return WebUiResources.webUiResource((String)("/webapp/" + path));
    }
}

