/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableSet;
import io.trino.sql.tree.DefaultTraversalVisitor;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SubqueryExpression;
import java.util.Objects;
import java.util.Set;

public final class NamesExtractor {
    private NamesExtractor() {
    }

    public static Set<QualifiedName> extractNames(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        new QualifiedNameBuilderVisitor(columnReferences, true).process((Node)expression, builder);
        return builder.build();
    }

    public static Set<QualifiedName> extractNamesNoSubqueries(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        new QualifiedNameBuilderVisitor(columnReferences, false).process((Node)expression, builder);
        return builder.build();
    }

    private static class QualifiedNameBuilderVisitor
    extends DefaultTraversalVisitor<ImmutableSet.Builder<QualifiedName>> {
        private final Set<NodeRef<Expression>> columnReferences;
        private final boolean recurseIntoSubqueries;

        private QualifiedNameBuilderVisitor(Set<NodeRef<Expression>> columnReferences, boolean recurseIntoSubqueries) {
            this.columnReferences = Objects.requireNonNull(columnReferences, "columnReferences is null");
            this.recurseIntoSubqueries = recurseIntoSubqueries;
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableSet.Builder<QualifiedName> builder) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                builder.add((Object)DereferenceExpression.getQualifiedName((DereferenceExpression)node));
            } else {
                this.process((Node)node.getBase(), builder);
            }
            return null;
        }

        protected Void visitIdentifier(Identifier node, ImmutableSet.Builder<QualifiedName> builder) {
            builder.add((Object)QualifiedName.of((String)node.getValue()));
            return null;
        }

        protected Void visitSubqueryExpression(SubqueryExpression node, ImmutableSet.Builder<QualifiedName> context) {
            if (!this.recurseIntoSubqueries) {
                return null;
            }
            return super.visitSubqueryExpression(node, context);
        }
    }
}

