/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import java.util.Map;
import java.util.Objects;

public class TypeAnalyzer {
    private final PlannerContext plannerContext;
    private final StatementAnalyzerFactory statementAnalyzerFactory;

    @Inject
    public TypeAnalyzer(PlannerContext plannerContext, StatementAnalyzerFactory statementAnalyzerFactory) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
    }

    public Map<NodeRef<Expression>, Type> getTypes(Session session, Iterable<Expression> expressions) {
        return ExpressionAnalyzer.analyzeExpressions(session, this.plannerContext, this.statementAnalyzerFactory, new AllowAllAccessControl(), expressions, (Map<NodeRef<Parameter>, Expression>)ImmutableMap.of(), WarningCollector.NOOP, QueryType.OTHERS).getExpressionTypes();
    }

    public Map<NodeRef<Expression>, Type> getTypes(Session session, Expression expression) {
        return this.getTypes(session, (Iterable<Expression>)ImmutableList.of((Object)expression));
    }

    public Type getType(Session session, Expression expression) {
        return this.getTypes(session, expression).get(NodeRef.of((Node)expression));
    }
}

