/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.gen.columnar.FilterEvaluator;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public final class AndFilterEvaluator
implements FilterEvaluator {
    private final List<FilterEvaluator> subFilterEvaluators;

    public static Optional<Supplier<FilterEvaluator>> createAndExpressionEvaluator(ColumnarFilterCompiler compiler, SpecialForm specialForm) {
        Preconditions.checkArgument((specialForm.form() == SpecialForm.Form.AND ? 1 : 0) != 0, (String)"specialForm %s should be AND", (Object)specialForm);
        Preconditions.checkArgument((specialForm.arguments().size() >= 2 ? 1 : 0) != 0, (String)"AND expression %s should have at least 2 arguments", (Object)specialForm);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RowExpression expression : specialForm.arguments()) {
            Optional<Supplier<FilterEvaluator>> subExpressionEvaluator = FilterEvaluator.createColumnarFilterEvaluator(expression, compiler);
            if (subExpressionEvaluator.isEmpty()) {
                return Optional.empty();
            }
            builder.add(subExpressionEvaluator.get());
        }
        ImmutableList subExpressionEvaluators = builder.build();
        return Optional.of(() -> AndFilterEvaluator.lambda$createAndExpressionEvaluator$0((List)subExpressionEvaluators));
    }

    private AndFilterEvaluator(List<FilterEvaluator> subFilterEvaluators) {
        Preconditions.checkArgument((subFilterEvaluators.size() >= 2 ? 1 : 0) != 0, (Object)"must have at least 2 subexpressions to AND");
        this.subFilterEvaluators = subFilterEvaluators;
    }

    @Override
    public FilterEvaluator.SelectionResult evaluate(ConnectorSession session, SelectedPositions activePositions, Page page) {
        long filterTimeNanos = 0L;
        for (FilterEvaluator evaluator : this.subFilterEvaluators) {
            FilterEvaluator.SelectionResult result = evaluator.evaluate(session, activePositions, page);
            filterTimeNanos += result.filterTimeNanos();
            activePositions = result.selectedPositions();
        }
        return new FilterEvaluator.SelectionResult(activePositions, filterTimeNanos);
    }

    private static /* synthetic */ FilterEvaluator lambda$createAndExpressionEvaluator$0(List subExpressionEvaluators) {
        return new AndFilterEvaluator((List)subExpressionEvaluators.stream().map(Supplier::get).collect(ImmutableList.toImmutableList()));
    }
}

