/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import com.google.errorprone.annotations.DoNotCall;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;

public record Constant(Type type, @JsonIgnore Object value) implements Expression
{
    public Constant {
        if (value != null && !Primitives.wrap((Class)type.getJavaType()).isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Improper Java type (%s) for type '%s'".formatted(value.getClass().getName(), type));
        }
    }

    @JsonCreator
    @DoNotCall
    public static Constant fromJson(@JsonProperty Type type, @JsonProperty Block valueAsBlock) {
        return new Constant(type, TypeUtils.readNativeValue((Type)type, (Block)valueAsBlock, (int)0));
    }

    @JsonProperty
    public Block getValueAsBlock() {
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)this.type, (BlockBuilder)blockBuilder, (Object)this.value);
        return blockBuilder.build();
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitConstant(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        return "[%s]::%s".formatted(this.value == null ? "<null>" : this.type.getObjectValue(null, this.getValueAsBlock(), 0), this.type);
    }
}

