/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Array;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Bind;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Case;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.Switch;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.ir.optimizer.rule.DesugarBetween;
import io.trino.sql.ir.optimizer.rule.DistributeComparisonOverCase;
import io.trino.sql.ir.optimizer.rule.DistributeComparisonOverSwitch;
import io.trino.sql.ir.optimizer.rule.EvaluateArray;
import io.trino.sql.ir.optimizer.rule.EvaluateBind;
import io.trino.sql.ir.optimizer.rule.EvaluateCall;
import io.trino.sql.ir.optimizer.rule.EvaluateCallWithNullInput;
import io.trino.sql.ir.optimizer.rule.EvaluateCase;
import io.trino.sql.ir.optimizer.rule.EvaluateCast;
import io.trino.sql.ir.optimizer.rule.EvaluateComparison;
import io.trino.sql.ir.optimizer.rule.EvaluateFieldReference;
import io.trino.sql.ir.optimizer.rule.EvaluateIn;
import io.trino.sql.ir.optimizer.rule.EvaluateIsNull;
import io.trino.sql.ir.optimizer.rule.EvaluateLogical;
import io.trino.sql.ir.optimizer.rule.EvaluateNullIf;
import io.trino.sql.ir.optimizer.rule.EvaluateReference;
import io.trino.sql.ir.optimizer.rule.EvaluateRow;
import io.trino.sql.ir.optimizer.rule.EvaluateSwitch;
import io.trino.sql.ir.optimizer.rule.FlattenCoalesce;
import io.trino.sql.ir.optimizer.rule.FlattenLogical;
import io.trino.sql.ir.optimizer.rule.RemoveRedundantCaseClauses;
import io.trino.sql.ir.optimizer.rule.RemoveRedundantCoalesceArguments;
import io.trino.sql.ir.optimizer.rule.RemoveRedundantInItems;
import io.trino.sql.ir.optimizer.rule.RemoveRedundantLogicalTerms;
import io.trino.sql.ir.optimizer.rule.RemoveRedundantSwitchClauses;
import io.trino.sql.ir.optimizer.rule.SimplifyComplementaryLogicalTerms;
import io.trino.sql.ir.optimizer.rule.SimplifyContinuousInValues;
import io.trino.sql.ir.optimizer.rule.SimplifyRedundantCase;
import io.trino.sql.ir.optimizer.rule.SimplifyRedundantCast;
import io.trino.sql.ir.optimizer.rule.SimplifyStackedArithmeticNegation;
import io.trino.sql.ir.optimizer.rule.SimplifyStackedNot;
import io.trino.sql.ir.optimizer.rule.SpecializeCastWithJsonParse;
import io.trino.sql.ir.optimizer.rule.SpecializeTransformWithJsonParse;
import io.trino.sql.planner.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IrExpressionOptimizer {
    private final List<IrOptimizerRule> rules;

    private IrExpressionOptimizer(List<IrOptimizerRule> rules) {
        this.rules = rules;
    }

    public static IrExpressionOptimizer newOptimizer(PlannerContext context) {
        return new IrExpressionOptimizer((List<IrOptimizerRule>)ImmutableList.of((Object)new EvaluateReference(), (Object)new EvaluateArray(), (Object)new EvaluateRow(), (Object)new EvaluateBind(), (Object)new EvaluateFieldReference(), (Object)new SimplifyComplementaryLogicalTerms(context), (Object)new EvaluateIsNull(), (Object)new EvaluateComparison(context), (Object)new EvaluateCast(context), (Object)new EvaluateNullIf(context), (Object)new EvaluateSwitch(context), (Object)new EvaluateCase(), (Object[])new IrOptimizerRule[]{new EvaluateCall(context), new EvaluateIn(context), new DesugarBetween(context), new EvaluateCallWithNullInput(), new RemoveRedundantSwitchClauses(context), new RemoveRedundantCaseClauses(), new RemoveRedundantInItems(context), new SimplifyContinuousInValues(), new SimplifyRedundantCast(), new SimplifyStackedNot(), new SimplifyStackedArithmeticNegation(), new FlattenCoalesce(), new RemoveRedundantCoalesceArguments(), new EvaluateLogical(), new FlattenLogical(), new RemoveRedundantLogicalTerms(), new DistributeComparisonOverSwitch(), new DistributeComparisonOverCase(), new SimplifyRedundantCase(context), new SpecializeCastWithJsonParse(context), new SpecializeTransformWithJsonParse(context)}));
    }

    public static IrExpressionOptimizer newPartialEvaluator(PlannerContext context) {
        return new IrExpressionOptimizer((List<IrOptimizerRule>)ImmutableList.of((Object)new EvaluateReference(), (Object)new EvaluateArray(), (Object)new EvaluateRow(), (Object)new EvaluateBind(), (Object)new EvaluateFieldReference(), (Object)new EvaluateIsNull(), (Object)new EvaluateComparison(context), (Object)new EvaluateCast(context), (Object)new EvaluateNullIf(context), (Object)new EvaluateSwitch(context), (Object)new EvaluateCase(), (Object)new EvaluateCall(context), (Object[])new IrOptimizerRule[]{new EvaluateIn(context), new DesugarBetween(context), new EvaluateLogical()}));
    }

    public Optional<Expression> process(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        boolean changed = false;
        boolean progress = true;
        while (progress) {
            progress = false;
            Optional<Expression> optimized = this.processChildren(expression, session, bindings);
            if (optimized.isPresent()) {
                expression = optimized.get();
                changed = true;
                progress = true;
            }
            if (!(optimized = this.applyRules(expression, session, bindings)).isPresent()) continue;
            expression = optimized.get();
            changed = true;
            progress = true;
        }
        return changed ? Optional.of(expression) : Optional.empty();
    }

    private Optional<Expression> processChildren(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Optional<Expression> optional;
        Expression expression2 = expression;
        Objects.requireNonNull(expression2);
        Expression expression3 = expression2;
        int n = 0;
        block19: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Reference.class, Constant.class, Cast.class, IsNull.class, Comparison.class, Logical.class, Call.class, Array.class, Row.class, Between.class, Coalesce.class, FieldReference.class, NullIf.class, In.class, Lambda.class, Bind.class, Switch.class, Case.class}, (Expression)expression3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
                case 1: {
                    if (!(expression3 instanceof Reference) && !(expression3 instanceof Constant)) {
                        n = 2;
                        continue block19;
                    }
                    optional = Optional.empty();
                    break block19;
                }
                case 2: {
                    Cast cast = (Cast)expression3;
                    optional = this.process(cast.expression(), session, bindings).map(value -> new Cast((Expression)value, cast.type()));
                    break block19;
                }
                case 3: {
                    IsNull isNull = (IsNull)expression3;
                    optional = this.process(isNull.value(), session, bindings).map(value -> new IsNull((Expression)value));
                    break block19;
                }
                case 4: {
                    Comparison comparison = (Comparison)expression3;
                    Optional<Expression> left = this.process(comparison.left(), session, bindings);
                    Optional<Expression> right = this.process(comparison.right(), session, bindings);
                    if (left.isPresent() || right.isPresent()) {
                        optional = Optional.of(new Comparison(comparison.operator(), left.orElse(comparison.left()), right.orElse(comparison.right())));
                        break block19;
                    }
                    optional = Optional.empty();
                    break block19;
                }
                case 5: {
                    Logical logical = (Logical)expression3;
                    optional = this.process(logical.terms(), session, bindings).map(arguments -> new Logical(logical.operator(), (List<Expression>)arguments));
                    break block19;
                }
                case 6: {
                    Call call = (Call)expression3;
                    optional = this.process(call.arguments(), session, bindings).map(arguments -> new Call(call.function(), (List<Expression>)arguments));
                    break block19;
                }
                case 7: {
                    Array array = (Array)expression3;
                    optional = this.process(array.elements(), session, bindings).map(elements -> new Array(array.elementType(), (List<Expression>)elements));
                    break block19;
                }
                case 8: {
                    Row row = (Row)expression3;
                    optional = this.process(row.items(), session, bindings).map(fields -> new Row((List<Expression>)fields));
                    break block19;
                }
                case 9: {
                    Between between = (Between)expression3;
                    Optional<Expression> value2 = this.process(between.value(), session, bindings);
                    Optional<Expression> min = this.process(between.min(), session, bindings);
                    Optional<Expression> max = this.process(between.max(), session, bindings);
                    if (value2.isPresent() || min.isPresent() || max.isPresent()) {
                        optional = Optional.of(new Between(value2.orElse(between.value()), min.orElse(between.min()), max.orElse(between.max())));
                        break block19;
                    }
                    optional = Optional.empty();
                    break block19;
                }
                case 10: {
                    Coalesce coalesce = (Coalesce)expression3;
                    optional = this.process(coalesce.operands(), session, bindings).map(operands -> new Coalesce((List<Expression>)operands));
                    break block19;
                }
                case 11: {
                    FieldReference reference = (FieldReference)expression3;
                    optional = this.process(reference.base(), session, bindings).map(base -> new FieldReference((Expression)base, reference.field()));
                    break block19;
                }
                case 12: {
                    NullIf nullIf = (NullIf)expression3;
                    Optional<Expression> first = this.process(nullIf.first(), session, bindings);
                    Optional<Expression> second = this.process(nullIf.second(), session, bindings);
                    if (first.isPresent() || second.isPresent()) {
                        optional = Optional.of(new NullIf(first.orElse(nullIf.first()), second.orElse(nullIf.second())));
                        break block19;
                    }
                    optional = Optional.empty();
                    break block19;
                }
                case 13: {
                    In in = (In)expression3;
                    Optional<Expression> value3 = this.process(in.value(), session, bindings);
                    Optional<List<Expression>> list = this.process(in.valueList(), session, bindings);
                    if (value3.isPresent() || list.isPresent()) {
                        optional = Optional.of(new In(value3.orElse(in.value()), list.orElse(in.valueList())));
                        break block19;
                    }
                    optional = Optional.empty();
                    break block19;
                }
                case 14: {
                    Lambda lambda = (Lambda)expression3;
                    optional = this.process(lambda.body(), session, bindings).map(body -> new Lambda(lambda.arguments(), (Expression)body));
                    break block19;
                }
                case 15: {
                    Bind bind = (Bind)expression3;
                    Optional<List<Expression>> values = this.process(bind.values(), session, bindings);
                    Optional<Expression> lambda = this.process(bind.function(), session, bindings);
                    if (values.isPresent() || lambda.isPresent()) {
                        optional = Optional.of(new Bind(values.orElse(bind.values()), (Lambda)lambda.orElse(bind.function())));
                        break block19;
                    }
                    optional = Optional.empty();
                    break block19;
                }
                case 16: {
                    Switch e = (Switch)expression3;
                    Optional<Expression> operand = this.process(e.operand(), session, bindings);
                    Optional<Expression> defaultValue = this.process(e.defaultValue(), session, bindings);
                    Optional<List<WhenClause>> clauses = this.processClauses(e.whenClauses(), session, bindings);
                    if (operand.isPresent() || clauses.isPresent() || defaultValue.isPresent()) {
                        optional = Optional.of(new Switch(operand.orElse(e.operand()), clauses.orElse(e.whenClauses()), defaultValue.orElse(e.defaultValue())));
                        break block19;
                    }
                    optional = Optional.empty();
                    break block19;
                }
                case 17: {
                    Case e = (Case)expression3;
                    Optional<Expression> defaultValue = this.process(e.defaultValue(), session, bindings);
                    Optional<List<WhenClause>> clauses = this.processClauses(e.whenClauses(), session, bindings);
                    if (clauses.isPresent() || defaultValue.isPresent()) {
                        optional = Optional.of(new Case(clauses.orElse(e.whenClauses()), defaultValue.orElse(e.defaultValue())));
                        break block19;
                    }
                    optional = Optional.empty();
                    break block19;
                }
            }
            break;
        }
        return optional;
    }

    private Optional<List<WhenClause>> processClauses(List<WhenClause> clauses, Session session, Map<Symbol, Expression> bindings) {
        boolean changed = false;
        ImmutableList.Builder optimized = ImmutableList.builder();
        for (WhenClause clause : clauses) {
            Optional<Expression> operand = this.process(clause.getOperand(), session, bindings);
            Optional<Expression> result = this.process(clause.getResult(), session, bindings);
            if (operand.isPresent() || result.isPresent()) {
                optimized.add((Object)new WhenClause(operand.orElse(clause.getOperand()), result.orElse(clause.getResult())));
            } else {
                optimized.add((Object)clause);
            }
            changed = changed || operand.isPresent() || result.isPresent();
        }
        return changed ? Optional.of(optimized.build()) : Optional.empty();
    }

    private Optional<List<Expression>> process(List<Expression> expressions, Session session, Map<Symbol, Expression> bindings) {
        boolean changed = false;
        ImmutableList.Builder result = ImmutableList.builder();
        for (Expression expression : expressions) {
            Optional<Expression> optimized = this.process(expression, session, bindings);
            changed = changed || optimized.isPresent();
            result.add((Object)optimized.orElse(expression));
        }
        return changed ? Optional.of(result.build()) : Optional.empty();
    }

    private Optional<Expression> applyRules(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        boolean changed = false;
        for (IrOptimizerRule rule : this.rules) {
            Optional<Expression> optimized = rule.apply(expression, session, bindings);
            if (!optimized.isPresent()) continue;
            Preconditions.checkState((boolean)expression.type().equals((Object)optimized.get().type()), (String)"Rule %s changed expression type from %s to %s", (Object)rule.getClass().getSimpleName(), (Object)expression.type(), (Object)optimized.get().type());
            expression = optimized.get();
            changed = true;
        }
        return changed ? Optional.of(expression) : Optional.empty();
    }
}

