/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.spi.function.FunctionNullability;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.Map;
import java.util.Optional;

public class EvaluateCallWithNullInput
implements IrOptimizerRule {
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        if (!(expression instanceof Call)) {
            return Optional.empty();
        }
        Call call = (Call)expression;
        FunctionNullability nullability = call.function().functionNullability();
        for (int i = 0; i < call.arguments().size(); ++i) {
            if (!IrExpressions.isConstantNull(call.arguments().get(i)) || nullability.isArgumentNullable(i)) continue;
            return Optional.of(new Constant(expression.type(), null));
        }
        return Optional.empty();
    }
}

