/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class FlattenCoalesce
implements IrOptimizerRule {
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        if (!(expression instanceof Coalesce)) {
            return Optional.empty();
        }
        Coalesce coalesce = (Coalesce)expression;
        if (coalesce.operands().stream().noneMatch(e -> e instanceof Coalesce)) {
            return Optional.empty();
        }
        return Optional.of(new Coalesce(this.flatten(coalesce).toList()));
    }

    private Stream<Expression> flatten(Coalesce coalesce) {
        return coalesce.operands().stream().flatMap(this::flatten);
    }

    private Stream<Expression> flatten(Expression expression) {
        if (expression instanceof Coalesce) {
            Coalesce coalesce = (Coalesce)expression;
            return this.flatten(coalesce);
        }
        return Stream.of(expression);
    }
}

