/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.SystemSessionProperties;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostComparator;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.cost.TaskCountEstimator;
import io.trino.execution.TaskManagerConfig;
import io.trino.metadata.Metadata;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.OptimizerStatsRecorder;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.RuleStats;
import io.trino.sql.planner.iterative.rule.AdaptiveReorderPartitionedJoin;
import io.trino.sql.planner.iterative.rule.AddDynamicFilterSource;
import io.trino.sql.planner.iterative.rule.AddExchangesBelowPartialAggregationOverGroupIdRuleSet;
import io.trino.sql.planner.iterative.rule.AddIntermediateAggregations;
import io.trino.sql.planner.iterative.rule.ApplyTableScanRedirection;
import io.trino.sql.planner.iterative.rule.ArraySortAfterArrayDistinct;
import io.trino.sql.planner.iterative.rule.CanonicalizeExpressions;
import io.trino.sql.planner.iterative.rule.CreatePartialTopN;
import io.trino.sql.planner.iterative.rule.DecorrelateInnerUnnestWithGlobalAggregation;
import io.trino.sql.planner.iterative.rule.DecorrelateLeftUnnestWithGlobalAggregation;
import io.trino.sql.planner.iterative.rule.DecorrelateUnnest;
import io.trino.sql.planner.iterative.rule.DesugarLambdaExpression;
import io.trino.sql.planner.iterative.rule.DetermineJoinDistributionType;
import io.trino.sql.planner.iterative.rule.DetermineSemiJoinDistributionType;
import io.trino.sql.planner.iterative.rule.DetermineTableScanNodePartitioning;
import io.trino.sql.planner.iterative.rule.EliminateCrossJoins;
import io.trino.sql.planner.iterative.rule.EvaluateEmptyIntersect;
import io.trino.sql.planner.iterative.rule.EvaluateZeroSample;
import io.trino.sql.planner.iterative.rule.ExtractDereferencesFromFilterAboveScan;
import io.trino.sql.planner.iterative.rule.ExtractSpatialJoins;
import io.trino.sql.planner.iterative.rule.GatherAndMergeWindows;
import io.trino.sql.planner.iterative.rule.GatherPartialTopN;
import io.trino.sql.planner.iterative.rule.ImplementBernoulliSampleAsFilter;
import io.trino.sql.planner.iterative.rule.ImplementExceptAll;
import io.trino.sql.planner.iterative.rule.ImplementExceptDistinctAsUnion;
import io.trino.sql.planner.iterative.rule.ImplementFilteredAggregations;
import io.trino.sql.planner.iterative.rule.ImplementIntersectAll;
import io.trino.sql.planner.iterative.rule.ImplementIntersectDistinctAsUnion;
import io.trino.sql.planner.iterative.rule.ImplementLimitWithTies;
import io.trino.sql.planner.iterative.rule.ImplementOffset;
import io.trino.sql.planner.iterative.rule.ImplementTableFunctionSource;
import io.trino.sql.planner.iterative.rule.InlineProjectIntoFilter;
import io.trino.sql.planner.iterative.rule.InlineProjections;
import io.trino.sql.planner.iterative.rule.MergeExcept;
import io.trino.sql.planner.iterative.rule.MergeFilters;
import io.trino.sql.planner.iterative.rule.MergeIntersect;
import io.trino.sql.planner.iterative.rule.MergeLimitOverProjectWithSort;
import io.trino.sql.planner.iterative.rule.MergeLimitWithDistinct;
import io.trino.sql.planner.iterative.rule.MergeLimitWithSort;
import io.trino.sql.planner.iterative.rule.MergeLimitWithTopN;
import io.trino.sql.planner.iterative.rule.MergeLimits;
import io.trino.sql.planner.iterative.rule.MergePatternRecognitionNodes;
import io.trino.sql.planner.iterative.rule.MergeProjectWithValues;
import io.trino.sql.planner.iterative.rule.MergeUnion;
import io.trino.sql.planner.iterative.rule.MultipleDistinctAggregationToMarkDistinct;
import io.trino.sql.planner.iterative.rule.MultipleDistinctAggregationsToSubqueries;
import io.trino.sql.planner.iterative.rule.OptimizeDuplicateInsensitiveJoins;
import io.trino.sql.planner.iterative.rule.OptimizeMixedDistinctAggregations;
import io.trino.sql.planner.iterative.rule.OptimizeRowPattern;
import io.trino.sql.planner.iterative.rule.PreAggregateCaseAggregations;
import io.trino.sql.planner.iterative.rule.PruneAggregationColumns;
import io.trino.sql.planner.iterative.rule.PruneAggregationSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneApplyColumns;
import io.trino.sql.planner.iterative.rule.PruneApplyCorrelation;
import io.trino.sql.planner.iterative.rule.PruneApplySourceColumns;
import io.trino.sql.planner.iterative.rule.PruneAssignUniqueIdColumns;
import io.trino.sql.planner.iterative.rule.PruneCorrelatedJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneCorrelatedJoinCorrelation;
import io.trino.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import io.trino.sql.planner.iterative.rule.PruneDistinctAggregation;
import io.trino.sql.planner.iterative.rule.PruneDistinctLimitSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneEnforceSingleRowColumns;
import io.trino.sql.planner.iterative.rule.PruneExceptSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneExchangeColumns;
import io.trino.sql.planner.iterative.rule.PruneExchangeSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneExplainAnalyzeSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneFilterColumns;
import io.trino.sql.planner.iterative.rule.PruneGroupIdColumns;
import io.trino.sql.planner.iterative.rule.PruneGroupIdSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneIndexJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneIndexSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneIntersectSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneJoinChildrenColumns;
import io.trino.sql.planner.iterative.rule.PruneJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneLimitColumns;
import io.trino.sql.planner.iterative.rule.PruneMarkDistinctColumns;
import io.trino.sql.planner.iterative.rule.PruneMergeSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneOffsetColumns;
import io.trino.sql.planner.iterative.rule.PruneOrderByInAggregation;
import io.trino.sql.planner.iterative.rule.PruneOutputSourceColumns;
import io.trino.sql.planner.iterative.rule.PrunePattenRecognitionColumns;
import io.trino.sql.planner.iterative.rule.PrunePatternRecognitionSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneProjectColumns;
import io.trino.sql.planner.iterative.rule.PruneRowNumberColumns;
import io.trino.sql.planner.iterative.rule.PruneSampleColumns;
import io.trino.sql.planner.iterative.rule.PruneSemiJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneSemiJoinFilteringSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneSortColumns;
import io.trino.sql.planner.iterative.rule.PruneSpatialJoinChildrenColumns;
import io.trino.sql.planner.iterative.rule.PruneSpatialJoinColumns;
import io.trino.sql.planner.iterative.rule.PruneTableExecuteSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneTableFunctionProcessorColumns;
import io.trino.sql.planner.iterative.rule.PruneTableFunctionProcessorSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneTableScanColumns;
import io.trino.sql.planner.iterative.rule.PruneTableWriterSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneTopNColumns;
import io.trino.sql.planner.iterative.rule.PruneTopNRankingColumns;
import io.trino.sql.planner.iterative.rule.PruneUnionColumns;
import io.trino.sql.planner.iterative.rule.PruneUnionSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneUnnestColumns;
import io.trino.sql.planner.iterative.rule.PruneUnnestSourceColumns;
import io.trino.sql.planner.iterative.rule.PruneValuesColumns;
import io.trino.sql.planner.iterative.rule.PruneWindowColumns;
import io.trino.sql.planner.iterative.rule.PushAggregationIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushAggregationThroughOuterJoin;
import io.trino.sql.planner.iterative.rule.PushCastIntoRow;
import io.trino.sql.planner.iterative.rule.PushDistinctLimitIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughFilter;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughJoin;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughProject;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughSemiJoin;
import io.trino.sql.planner.iterative.rule.PushDownDereferenceThroughUnnest;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughAssignUniqueId;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughLimit;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughMarkDistinct;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughRowNumber;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughSort;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughTopN;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughTopNRanking;
import io.trino.sql.planner.iterative.rule.PushDownDereferencesThroughWindow;
import io.trino.sql.planner.iterative.rule.PushDownProjectionsFromPatternRecognition;
import io.trino.sql.planner.iterative.rule.PushFilterIntoValues;
import io.trino.sql.planner.iterative.rule.PushFilterThroughBoolOrAggregation;
import io.trino.sql.planner.iterative.rule.PushFilterThroughCountAggregation;
import io.trino.sql.planner.iterative.rule.PushInequalityFilterExpressionBelowJoinRuleSet;
import io.trino.sql.planner.iterative.rule.PushJoinIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushLimitIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushLimitThroughMarkDistinct;
import io.trino.sql.planner.iterative.rule.PushLimitThroughOffset;
import io.trino.sql.planner.iterative.rule.PushLimitThroughOuterJoin;
import io.trino.sql.planner.iterative.rule.PushLimitThroughProject;
import io.trino.sql.planner.iterative.rule.PushLimitThroughSemiJoin;
import io.trino.sql.planner.iterative.rule.PushLimitThroughUnion;
import io.trino.sql.planner.iterative.rule.PushMergeWriterDeleteIntoConnector;
import io.trino.sql.planner.iterative.rule.PushMergeWriterUpdateIntoConnector;
import io.trino.sql.planner.iterative.rule.PushOffsetThroughProject;
import io.trino.sql.planner.iterative.rule.PushPartialAggregationThroughExchange;
import io.trino.sql.planner.iterative.rule.PushPartialAggregationThroughJoin;
import io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushPredicateThroughProjectIntoRowNumber;
import io.trino.sql.planner.iterative.rule.PushPredicateThroughProjectIntoWindow;
import io.trino.sql.planner.iterative.rule.PushProjectionIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughExchange;
import io.trino.sql.planner.iterative.rule.PushProjectionThroughUnion;
import io.trino.sql.planner.iterative.rule.PushRemoteExchangeThroughAssignUniqueId;
import io.trino.sql.planner.iterative.rule.PushSampleIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushTableWriteThroughUnion;
import io.trino.sql.planner.iterative.rule.PushTopNIntoTableScan;
import io.trino.sql.planner.iterative.rule.PushTopNThroughOuterJoin;
import io.trino.sql.planner.iterative.rule.PushTopNThroughProject;
import io.trino.sql.planner.iterative.rule.PushTopNThroughUnion;
import io.trino.sql.planner.iterative.rule.PushdownFilterIntoRowNumber;
import io.trino.sql.planner.iterative.rule.PushdownFilterIntoWindow;
import io.trino.sql.planner.iterative.rule.PushdownLimitIntoRowNumber;
import io.trino.sql.planner.iterative.rule.PushdownLimitIntoWindow;
import io.trino.sql.planner.iterative.rule.RemoveAggregationInSemiJoin;
import io.trino.sql.planner.iterative.rule.RemoveDuplicateConditions;
import io.trino.sql.planner.iterative.rule.RemoveEmptyExceptBranches;
import io.trino.sql.planner.iterative.rule.RemoveEmptyGlobalAggregation;
import io.trino.sql.planner.iterative.rule.RemoveEmptyMergeWriterRuleSet;
import io.trino.sql.planner.iterative.rule.RemoveEmptyTableExecute;
import io.trino.sql.planner.iterative.rule.RemoveEmptyUnionBranches;
import io.trino.sql.planner.iterative.rule.RemoveFullSample;
import io.trino.sql.planner.iterative.rule.RemoveRedundantDateTrunc;
import io.trino.sql.planner.iterative.rule.RemoveRedundantDistinctAggregation;
import io.trino.sql.planner.iterative.rule.RemoveRedundantDistinctLimit;
import io.trino.sql.planner.iterative.rule.RemoveRedundantEnforceSingleRowNode;
import io.trino.sql.planner.iterative.rule.RemoveRedundantExists;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.iterative.rule.RemoveRedundantJoin;
import io.trino.sql.planner.iterative.rule.RemoveRedundantLimit;
import io.trino.sql.planner.iterative.rule.RemoveRedundantOffset;
import io.trino.sql.planner.iterative.rule.RemoveRedundantPredicateAboveTableScan;
import io.trino.sql.planner.iterative.rule.RemoveRedundantSort;
import io.trino.sql.planner.iterative.rule.RemoveRedundantSortBelowLimitWithTies;
import io.trino.sql.planner.iterative.rule.RemoveRedundantTableFunction;
import io.trino.sql.planner.iterative.rule.RemoveRedundantTopN;
import io.trino.sql.planner.iterative.rule.RemoveRedundantWindow;
import io.trino.sql.planner.iterative.rule.RemoveTrivialFilters;
import io.trino.sql.planner.iterative.rule.RemoveUnreferencedScalarApplyNodes;
import io.trino.sql.planner.iterative.rule.RemoveUnreferencedScalarSubqueries;
import io.trino.sql.planner.iterative.rule.RemoveUnsupportedDynamicFilters;
import io.trino.sql.planner.iterative.rule.ReorderJoins;
import io.trino.sql.planner.iterative.rule.ReplaceJoinOverConstantWithProject;
import io.trino.sql.planner.iterative.rule.ReplaceRedundantJoinWithProject;
import io.trino.sql.planner.iterative.rule.ReplaceRedundantJoinWithSource;
import io.trino.sql.planner.iterative.rule.ReplaceWindowWithRowNumber;
import io.trino.sql.planner.iterative.rule.RewriteSpatialPartitioningAggregation;
import io.trino.sql.planner.iterative.rule.RewriteTableFunctionToTableScan;
import io.trino.sql.planner.iterative.rule.SimplifyCountOverConstant;
import io.trino.sql.planner.iterative.rule.SimplifyExpressions;
import io.trino.sql.planner.iterative.rule.SimplifyFilterPredicate;
import io.trino.sql.planner.iterative.rule.SingleDistinctAggregationToGroupBy;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedDistinctAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedDistinctAggregationWithoutProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGlobalAggregationWithoutProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGroupedAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGroupedAggregationWithoutProjection;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedInPredicateToJoin;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedJoinToJoin;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedScalarSubquery;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import io.trino.sql.planner.iterative.rule.TransformExistsApplyToCorrelatedJoin;
import io.trino.sql.planner.iterative.rule.TransformFilteringSemiJoinToInnerJoin;
import io.trino.sql.planner.iterative.rule.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import io.trino.sql.planner.iterative.rule.TransformUncorrelatedSubqueryToJoin;
import io.trino.sql.planner.iterative.rule.UnwrapCastInComparison;
import io.trino.sql.planner.iterative.rule.UnwrapDateTruncInComparison;
import io.trino.sql.planner.iterative.rule.UnwrapRowSubscript;
import io.trino.sql.planner.iterative.rule.UnwrapSingleColumnRowInApply;
import io.trino.sql.planner.iterative.rule.UnwrapYearInComparison;
import io.trino.sql.planner.iterative.rule.UseNonPartitionedJoinLookupSource;
import io.trino.sql.planner.optimizations.AdaptivePartitioning;
import io.trino.sql.planner.optimizations.AdaptivePlanOptimizer;
import io.trino.sql.planner.optimizations.AddExchanges;
import io.trino.sql.planner.optimizations.AddLocalExchanges;
import io.trino.sql.planner.optimizations.BeginTableWrite;
import io.trino.sql.planner.optimizations.CheckSubqueryNodesAreRewritten;
import io.trino.sql.planner.optimizations.DeterminePartitionCount;
import io.trino.sql.planner.optimizations.HashGenerationOptimizer;
import io.trino.sql.planner.optimizations.IndexJoinOptimizer;
import io.trino.sql.planner.optimizations.LimitPushDown;
import io.trino.sql.planner.optimizations.MetadataQueryOptimizer;
import io.trino.sql.planner.optimizations.OptimizerStats;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.PredicatePushDown;
import io.trino.sql.planner.optimizations.StatsRecordingPlanOptimizer;
import io.trino.sql.planner.optimizations.TransformQuantifiedComparisonApplyToCorrelatedJoin;
import io.trino.sql.planner.optimizations.UnaliasSymbolReferences;
import io.trino.sql.planner.optimizations.WindowFilterPushDown;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PlanOptimizers
implements PlanOptimizersFactory {
    private final List<PlanOptimizer> optimizers;
    private final List<AdaptivePlanOptimizer> adaptivePlanOptimizers;
    private final RuleStatsRecorder ruleStats;
    private final OptimizerStatsRecorder optimizerStats = new OptimizerStatsRecorder();

    @Inject
    public PlanOptimizers(PlannerContext plannerContext, TaskManagerConfig taskManagerConfig, SplitManager splitManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, ScalarStatsCalculator scalarStatsCalculator, CostCalculator costCalculatorWithoutEstimatedExchanges, @CostCalculator.EstimatedExchanges CostCalculator costCalculatorWithEstimatedExchanges, CostComparator costComparator, TaskCountEstimator taskCountEstimator, NodePartitioningManager nodePartitioningManager, RuleStatsRecorder ruleStats) {
        this(plannerContext, taskManagerConfig, false, splitManager, pageSourceManager, statsCalculator, scalarStatsCalculator, costCalculatorWithoutEstimatedExchanges, costCalculatorWithEstimatedExchanges, costComparator, taskCountEstimator, nodePartitioningManager, ruleStats);
    }

    public PlanOptimizers(PlannerContext plannerContext, TaskManagerConfig taskManagerConfig, boolean forceSingleNode, SplitManager splitManager, PageSourceManager pageSourceManager, StatsCalculator statsCalculator, ScalarStatsCalculator scalarStatsCalculator, CostCalculator costCalculatorWithoutEstimatedExchanges, CostCalculator costCalculatorWithEstimatedExchanges, CostComparator costComparator, TaskCountEstimator taskCountEstimator, NodePartitioningManager nodePartitioningManager, RuleStatsRecorder ruleStats) {
        CostCalculator costCalculator = costCalculatorWithEstimatedExchanges;
        this.ruleStats = Objects.requireNonNull(ruleStats, "ruleStats is null");
        ImmutableList.Builder builder = ImmutableList.builder();
        Metadata metadata = plannerContext.getMetadata();
        Set<Rule<?>> columnPruningRules = PlanOptimizers.columnPruningRules(metadata);
        ImmutableSet projectionPushdownRules = ImmutableSet.of((Object)new PushProjectionThroughUnion(), (Object)new PushProjectionThroughExchange(), (Object)new PushDownDereferencesThroughMarkDistinct(), (Object)new PushDownDereferenceThroughProject(), (Object)new PushDownDereferenceThroughUnnest(), (Object)new PushDownDereferenceThroughSemiJoin(), (Object[])new Rule[]{new PushDownDereferenceThroughJoin(), new PushDownDereferenceThroughFilter(), new ExtractDereferencesFromFilterAboveScan(), new PushDownDereferencesThroughLimit(), new PushDownDereferencesThroughSort(), new PushDownDereferencesThroughAssignUniqueId(), new PushDownDereferencesThroughWindow(), new PushDownDereferencesThroughTopN(), new PushDownDereferencesThroughRowNumber(), new PushDownDereferencesThroughTopNRanking()});
        ImmutableSet limitPushdownRules = ImmutableSet.of((Object)new PushLimitThroughOffset(), (Object)new PushLimitThroughProject(), (Object)new PushLimitThroughMarkDistinct(), (Object)new PushLimitThroughOuterJoin(), (Object)new PushLimitThroughSemiJoin(), (Object)new PushLimitThroughUnion(), (Object[])new Rule[0]);
        IterativeOptimizer inlineProjections = new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(), (Object)new RemoveRedundantIdentityProjections()));
        ImmutableSet simplifyOptimizerRules = ImmutableSet.builder().addAll(new SimplifyExpressions(plannerContext).rules()).addAll(new UnwrapRowSubscript(plannerContext).rules()).addAll(new PushCastIntoRow().rules()).addAll(new UnwrapCastInComparison(plannerContext).rules()).addAll(new UnwrapDateTruncInComparison(plannerContext).rules()).addAll(new UnwrapYearInComparison(plannerContext).rules()).addAll(new RemoveDuplicateConditions().rules()).addAll(new CanonicalizeExpressions(plannerContext).rules()).addAll(new RemoveRedundantDateTrunc(plannerContext).rules()).addAll(new ArraySortAfterArrayDistinct(plannerContext).rules()).add((Object)new RemoveTrivialFilters()).build();
        IterativeOptimizer simplifyOptimizer = new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)simplifyOptimizerRules);
        IterativeOptimizer columnPruningOptimizer = new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, columnPruningRules);
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new DesugarLambdaExpression().rules()).build()), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(new CanonicalizeExpressions(plannerContext).rules()).add((Object)new OptimizeRowPattern()).build()), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(columnPruningRules).addAll((Iterable)projectionPushdownRules).addAll((Iterable)simplifyOptimizerRules).addAll(new UnwrapRowSubscript(plannerContext).rules()).addAll(new PushCastIntoRow().rules()).addAll((Iterable)ImmutableSet.of((Object)new ImplementTableFunctionSource(metadata), (Object)new UnwrapSingleColumnRowInApply(), (Object)new RemoveEmptyUnionBranches(), (Object)new EvaluateEmptyIntersect(), (Object)new RemoveEmptyExceptBranches(), (Object)new MergeFilters(), (Object[])new Rule[]{new InlineProjections(), new RemoveRedundantIdentityProjections(), new RemoveFullSample(), new EvaluateZeroSample(), new PushOffsetThroughProject(), new MergeUnion(), new MergeLimits(), new MergeLimitWithSort(), new MergeLimitOverProjectWithSort(), new MergeLimitWithTopN(), new RemoveTrivialFilters(), new RemoveRedundantLimit(), new RemoveRedundantOffset(), new RemoveRedundantSort(), new RemoveRedundantSortBelowLimitWithTies(), new RemoveRedundantTableFunction(), new RemoveRedundantTopN(), new RemoveRedundantDistinctLimit(), new ReplaceRedundantJoinWithSource(), new RemoveRedundantJoin(), new ReplaceRedundantJoinWithProject(), new RemoveRedundantEnforceSingleRowNode(), new RemoveRedundantExists(), new RemoveRedundantWindow(), new ImplementFilteredAggregations(), new SingleDistinctAggregationToGroupBy(), new MergeLimitWithDistinct(), new PruneCountAggregationOverScalar(metadata), new PruneOrderByInAggregation(metadata), new RewriteSpatialPartitioningAggregation(plannerContext), new SimplifyCountOverConstant(plannerContext), new PreAggregateCaseAggregations(plannerContext), new RemoveRedundantDistinctAggregation()})).build()), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)projectionPushdownRules).addAll(columnPruningRules).addAll((Iterable)limitPushdownRules).addAll((Iterable)ImmutableSet.of((Object)new MergeUnion(), (Object)new RemoveEmptyUnionBranches(), (Object)new MergeFilters(), (Object)new RemoveTrivialFilters(), (Object)new MergeLimits(), (Object)new MergeLimitWithSort(), (Object[])new Rule[]{new MergeLimitOverProjectWithSort(), new MergeLimitWithTopN(), new InlineProjections(), new RemoveRedundantIdentityProjections()})).build()), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementOffset())), simplifyOptimizer, new UnaliasSymbolReferences(), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new MergeUnion(), (Object)new MergeIntersect(), (Object)new MergeExcept(), (Object)new PruneDistinctAggregation())), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementIntersectDistinctAsUnion(metadata), (Object)new ImplementExceptDistinctAsUnion(metadata), (Object)new ImplementIntersectAll(metadata), (Object)new ImplementExceptAll(metadata))), new LimitPushDown(), columnPruningOptimizer, inlineProjections, new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, columnPruningRules), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new TransformExistsApplyToCorrelatedJoin(plannerContext))), new TransformQuantifiedComparisonApplyToCorrelatedJoin(metadata), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantEnforceSingleRowNode(), (Object)new RemoveUnreferencedScalarSubqueries(), (Object)new TransformUncorrelatedSubqueryToJoin(), (Object)new TransformUncorrelatedInPredicateSubqueryToSemiJoin(), (Object)new TransformCorrelatedJoinToJoin(plannerContext), (Object)new DecorrelateInnerUnnestWithGlobalAggregation(metadata), (Object[])new Rule[]{new DecorrelateLeftUnnestWithGlobalAggregation(), new DecorrelateUnnest(metadata), new TransformCorrelatedGlobalAggregationWithProjection(plannerContext), new TransformCorrelatedGlobalAggregationWithoutProjection(plannerContext), new TransformCorrelatedDistinctAggregationWithProjection(plannerContext), new TransformCorrelatedDistinctAggregationWithoutProjection(plannerContext), new TransformCorrelatedGroupedAggregationWithProjection(plannerContext), new TransformCorrelatedGroupedAggregationWithoutProjection(plannerContext)})), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementLimitWithTies(metadata), (Object)new RemoveUnreferencedScalarApplyNodes(), (Object)new TransformCorrelatedInPredicateToJoin(metadata), (Object)new TransformCorrelatedScalarSubquery(metadata), (Object)new TransformCorrelatedJoinToJoin(plannerContext), (Object)new ImplementFilteredAggregations(), (Object[])new Rule[0])), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new InlineProjections(), (Object)new RemoveRedundantIdentityProjections(), (Object)new TransformCorrelatedSingleRowSubqueryToProject(), (Object)new RemoveAggregationInSemiJoin(), (Object)new MergeProjectWithValues(), (Object)new ReplaceJoinOverConstantWithProject(), (Object[])new Rule[0])), new CheckSubqueryNodesAreRewritten(), simplifyOptimizer, new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(plannerContext, false, false)), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyUnionBranches(), (Object)new EvaluateEmptyIntersect(), (Object)new RemoveEmptyExceptBranches(), (Object)new PushFilterIntoValues(plannerContext), (Object)new ReplaceJoinOverConstantWithProject(), (Object)new TransformFilteringSemiJoinToInnerJoin(), (Object[])new Rule[]{new RemoveRedundantDistinctAggregation()})), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new InlineProjectIntoFilter()).add((Object)new SimplifyFilterPredicate(metadata)).addAll(columnPruningRules).add((Object)new InlineProjections()).addAll(new PushFilterThroughCountAggregation(plannerContext).rules()).addAll(new PushFilterThroughBoolOrAggregation(plannerContext).rules()).build())});
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ApplyTableScanRedirection(plannerContext), (Object)new PruneTableScanColumns(metadata), (Object)new PushPredicateIntoTableScan(plannerContext, false))));
        ImmutableSet pushIntoTableScanRulesExceptJoins = ImmutableSet.builder().addAll(columnPruningRules).addAll((Iterable)projectionPushdownRules).add((Object)new PushProjectionIntoTableScan(plannerContext, scalarStatsCalculator)).add((Object)new RemoveRedundantIdentityProjections()).add((Object)new PushLimitIntoTableScan(metadata)).add((Object)new PushPredicateIntoTableScan(plannerContext, false)).add((Object)new PushSampleIntoTableScan(metadata)).add((Object)new PushAggregationIntoTableScan(plannerContext)).add((Object)new PushDistinctLimitIntoTableScan(plannerContext)).add((Object)new PushTopNIntoTableScan(metadata)).add((Object)new RewriteTableFunctionToTableScan(plannerContext)).build();
        IterativeOptimizer pushIntoTableScanOptimizer = new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)pushIntoTableScanRulesExceptJoins);
        builder.add((Object)pushIntoTableScanOptimizer);
        builder.add((Object)new UnaliasSymbolReferences());
        builder.add((Object)pushIntoTableScanOptimizer);
        IterativeOptimizer pushProjectionIntoTableScanOptimizer = new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)projectionPushdownRules).add((Object)new PushProjectionIntoTableScan(plannerContext, scalarStatsCalculator)).build());
        builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ImplementBernoulliSampleAsFilter(metadata))), columnPruningOptimizer, new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyUnionBranches(), (Object)new EvaluateEmptyIntersect(), (Object)new RemoveEmptyExceptBranches(), (Object)new RemoveRedundantIdentityProjections(), (Object)new PushAggregationThroughOuterJoin(), (Object)new ReplaceRedundantJoinWithSource(), (Object[])new Rule[]{new MultipleDistinctAggregationsToSubqueries(taskCountEstimator, metadata), new SingleDistinctAggregationToGroupBy(), new OptimizeMixedDistinctAggregations(plannerContext, taskCountEstimator), new ImplementFilteredAggregations(), new MultipleDistinctAggregationToMarkDistinct(taskCountEstimator, metadata)})), inlineProjections, simplifyOptimizer, pushProjectionIntoTableScanOptimizer, new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(plannerContext, true, false)), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new PushPredicateIntoTableScan(plannerContext, false)).build()), new UnaliasSymbolReferences(), columnPruningOptimizer, new IndexJoinOptimizer(plannerContext), new LimitPushDown(), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, SystemSessionProperties::useLegacyWindowFilterPushdown, (List<PlanOptimizer>)ImmutableList.of((Object)new WindowFilterPushDown(plannerContext)), (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveEmptyUnionBranches(), (Object)new EvaluateEmptyIntersect(), (Object)new RemoveEmptyExceptBranches(), (Object)new PushdownLimitIntoRowNumber(), (Object)new PushdownLimitIntoWindow(), (Object)new PushdownFilterIntoRowNumber(plannerContext), (Object[])new Rule[]{new PushdownFilterIntoWindow(plannerContext), new PushFilterIntoValues(plannerContext), new ReplaceJoinOverConstantWithProject(), new ReplaceWindowWithRowNumber(metadata)})), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(GatherAndMergeWindows.rules()).addAll(MergePatternRecognitionNodes.rules()).add((Object)new PushPredicateThroughProjectIntoRowNumber(plannerContext)).add((Object)new PushPredicateThroughProjectIntoWindow(plannerContext)).build()), inlineProjections, columnPruningOptimizer, new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new PushDownProjectionsFromPatternRecognition())), new MetadataQueryOptimizer(plannerContext), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new EliminateCrossJoins(), (Object)new RemoveRedundantJoin())), new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(plannerContext, true, false)), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new PushPredicateIntoTableScan(plannerContext, false)).build()), pushProjectionIntoTableScanOptimizer, new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(plannerContext, true, false)), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new PushPredicateIntoTableScan(plannerContext, false)).build()), columnPruningOptimizer, new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new ReorderJoins(plannerContext, costComparator))), new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(plannerContext, true, false))});
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new CreatePartialTopN(), (Object)new PushTopNThroughProject(), (Object)new PushTopNThroughOuterJoin(), (Object)new PushTopNThroughUnion(), (Object)new PushTopNIntoTableScan(metadata))));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll(new ExtractSpatialJoins(plannerContext, splitManager, pageSourceManager).rules()).add((Object)new InlineProjections()).add((Object)new PushFilterIntoValues(plannerContext)).add((Object)new ReplaceJoinOverConstantWithProject()).build()));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushMergeWriterDeleteIntoConnector(metadata), (Object)new PushMergeWriterUpdateIntoConnector(metadata), (Object)new DetermineTableScanNodePartitioning(metadata, nodePartitioningManager, taskCountEstimator), (Object)new OptimizeDuplicateInsensitiveJoins())));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushPredicateIntoTableScan(plannerContext, true), (Object)new RemoveEmptyUnionBranches(), (Object)new EvaluateEmptyIntersect(), (Object)new RemoveEmptyExceptBranches(), (Object)new TransformFilteringSemiJoinToInnerJoin())));
        if (!forceSingleNode) {
            builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new DetermineJoinDistributionType(costComparator, taskCountEstimator), (Object)new DetermineSemiJoinDistributionType(costComparator, taskCountEstimator))));
            builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)pushIntoTableScanRulesExceptJoins).add((Object)new PushJoinIntoTableScan(plannerContext)).add((Object)new DetermineTableScanNodePartitioning(metadata, nodePartitioningManager, taskCountEstimator)).build()));
            builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushTableWriteThroughUnion())));
            builder.add((Object)new UnaliasSymbolReferences());
            builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new AddExchanges(plannerContext, statsCalculator, taskCountEstimator)));
            builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new DeterminePartitionCount(statsCalculator, taskCountEstimator)));
        }
        costCalculator = costCalculatorWithoutEstimatedExchanges;
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll(RemoveEmptyMergeWriterRuleSet.rules()).add((Object)new RemoveEmptyTableExecute()).build()));
        builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(plannerContext, true, false)));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new PushFilterIntoValues(plannerContext)).add((Object)new ReplaceJoinOverConstantWithProject()).add((Object)new RemoveRedundantPredicateAboveTableScan(plannerContext)).build()));
        builder.add((Object)pushProjectionIntoTableScanOptimizer);
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.copyOf(new PushInequalityFilterExpressionBelowJoinRuleSet().rules())));
        builder.add((Object)new StatsRecordingPlanOptimizer(this.optimizerStats, new PredicatePushDown(plannerContext, true, true)));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().addAll((Iterable)simplifyOptimizerRules).add((Object)new PushPredicateIntoTableScan(plannerContext, false)).add((Object)new PushFilterIntoValues(plannerContext)).add((Object)new ReplaceJoinOverConstantWithProject()).add((Object)new RemoveRedundantPredicateAboveTableScan(plannerContext)).build()));
        builder.add((Object)new RemoveUnsupportedDynamicFilters(plannerContext));
        builder.add((Object)inlineProjections);
        builder.add((Object)new UnaliasSymbolReferences());
        builder.add((Object)columnPruningOptimizer);
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).add((Object)new PushRemoteExchangeThroughAssignUniqueId()).add((Object)new InlineProjections()).build()));
        builder.add((Object)new AddLocalExchanges(plannerContext));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new UseNonPartitionedJoinLookupSource(), (Object)new GatherPartialTopN())));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new PushPartialAggregationThroughJoin(), (Object)new PushPartialAggregationThroughExchange(plannerContext), (Object)new PruneJoinColumns(), (Object)new PruneJoinChildrenColumns())));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, new AddExchangesBelowPartialAggregationOverGroupIdRuleSet(plannerContext, taskCountEstimator, taskManagerConfig).rules()));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new AddIntermediateAggregations(), (Object)new RemoveRedundantIdentityProjections())));
        builder.add((Object)new HashGenerationOptimizer(metadata));
        builder.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, AddDynamicFilterSource.rules()));
        builder.add((Object)new RemoveUnsupportedDynamicFilters(plannerContext));
        builder.add((Object)new BeginTableWrite(metadata, plannerContext.getFunctionManager()));
        this.optimizers = builder.build();
        ImmutableList.Builder adaptivePlanOptimizers = ImmutableList.builder();
        adaptivePlanOptimizers.add((Object)new AdaptivePartitioning());
        adaptivePlanOptimizers.add((Object)new IterativeOptimizer(plannerContext, ruleStats, statsCalculator, costCalculator, (Set<Rule<?>>)ImmutableSet.of((Object)new AdaptiveReorderPartitionedJoin(metadata))));
        this.adaptivePlanOptimizers = adaptivePlanOptimizers.build();
    }

    @VisibleForTesting
    public static Set<Rule<?>> columnPruningRules(Metadata metadata) {
        return ImmutableSet.of((Object)new PruneAggregationColumns(), (Object)new RemoveEmptyGlobalAggregation(), (Object)new PruneAggregationSourceColumns(), (Object)new PruneApplyColumns(), (Object)new PruneApplyCorrelation(), (Object)new PruneApplySourceColumns(), (Object[])new Rule[]{new PruneAssignUniqueIdColumns(), new PruneCorrelatedJoinColumns(), new PruneCorrelatedJoinCorrelation(), new PruneDistinctLimitSourceColumns(), new PruneEnforceSingleRowColumns(), new PruneExceptSourceColumns(), new PruneExchangeColumns(), new PruneExchangeSourceColumns(), new PruneExplainAnalyzeSourceColumns(), new PruneFilterColumns(), new PruneGroupIdColumns(), new PruneGroupIdSourceColumns(), new PruneIndexJoinColumns(), new PruneIndexSourceColumns(), new PruneIntersectSourceColumns(), new PruneJoinChildrenColumns(), new PruneJoinColumns(), new PruneLimitColumns(), new PruneMarkDistinctColumns(), new PruneMergeSourceColumns(), new PruneOffsetColumns(), new PruneOutputSourceColumns(), new PrunePattenRecognitionColumns(), new PrunePatternRecognitionSourceColumns(), new PruneProjectColumns(), new PruneRowNumberColumns(), new PruneSampleColumns(), new PruneSemiJoinColumns(), new PruneSemiJoinFilteringSourceColumns(), new PruneSortColumns(), new PruneSpatialJoinChildrenColumns(), new PruneSpatialJoinColumns(), new PruneTableExecuteSourceColumns(), new PruneTableFunctionProcessorColumns(), new PruneTableFunctionProcessorSourceColumns(), new PruneTableScanColumns(metadata), new PruneTableWriterSourceColumns(), new PruneTopNColumns(), new PruneTopNRankingColumns(), new PruneUnionColumns(), new PruneUnionSourceColumns(), new PruneUnnestColumns(), new PruneUnnestSourceColumns(), new PruneValuesColumns(), new PruneWindowColumns()});
    }

    @Override
    public List<PlanOptimizer> getPlanOptimizers() {
        return this.optimizers;
    }

    @Override
    public List<AdaptivePlanOptimizer> getAdaptivePlanOptimizers() {
        return this.adaptivePlanOptimizers;
    }

    @Override
    public Map<Class<?>, OptimizerStats> getOptimizerStats() {
        return this.optimizerStats.getStats();
    }

    @Override
    public Map<Class<?>, RuleStats> getRuleStats() {
        return this.ruleStats.getStats();
    }
}

