/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Logical;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class NormalizeOrExpressionRewriter {
    public static Expression normalizeOrExpression(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith(new Visitor(), expression);
    }

    private NormalizeOrExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        @Override
        public Expression rewriteLogical(Logical node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List terms = (List)node.terms().stream().map(expression -> treeRewriter.rewrite(expression, context)).collect(ImmutableList.toImmutableList());
            if (node.operator() == Logical.Operator.AND) {
                return IrUtils.and(terms);
            }
            ImmutableList.Builder inPredicateBuilder = ImmutableList.builder();
            ImmutableSet.Builder expressionToSkipBuilder = ImmutableSet.builder();
            ImmutableList.Builder othersExpressionBuilder = ImmutableList.builder();
            this.groupComparisonAndInPredicate(terms).forEach((expression, values) -> {
                if (values.size() > 1) {
                    inPredicateBuilder.add((Object)new In((Expression)expression, this.mergeToInListExpression((Collection<Expression>)values)));
                    expressionToSkipBuilder.add(expression);
                }
            });
            ImmutableSet expressionToSkip = expressionToSkipBuilder.build();
            for (Expression expression2 : terms) {
                Comparison comparison;
                if (expression2 instanceof Comparison && (comparison = (Comparison)expression2).operator() == Comparison.Operator.EQUAL) {
                    if (expressionToSkip.contains(comparison.left())) continue;
                    othersExpressionBuilder.add((Object)expression2);
                    continue;
                }
                if (expression2 instanceof In) {
                    In in = (In)expression2;
                    if (expressionToSkip.contains(in.value())) continue;
                    othersExpressionBuilder.add((Object)expression2);
                    continue;
                }
                othersExpressionBuilder.add((Object)expression2);
            }
            return IrUtils.or((Collection<Expression>)ImmutableList.builder().addAll((Iterable)othersExpressionBuilder.build()).addAll((Iterable)inPredicateBuilder.build()).build());
        }

        private List<Expression> mergeToInListExpression(Collection<Expression> expressions) {
            LinkedHashSet<Expression> expressionValues = new LinkedHashSet<Expression>();
            for (Expression expression : expressions) {
                Comparison comparison;
                if (expression instanceof Comparison && (comparison = (Comparison)expression).operator() == Comparison.Operator.EQUAL) {
                    expressionValues.add(comparison.right());
                    continue;
                }
                if (expression instanceof In) {
                    In in = (In)expression;
                    expressionValues.addAll(in.valueList());
                    continue;
                }
                throw new IllegalStateException("Unexpected expression: " + String.valueOf(expression));
            }
            return ImmutableList.copyOf(expressionValues);
        }

        private Map<Expression, Collection<Expression>> groupComparisonAndInPredicate(List<Expression> terms) {
            ImmutableMultimap.Builder expressionBuilder = ImmutableMultimap.builder();
            for (Expression expression : terms) {
                Comparison comparison;
                if (expression instanceof Comparison && (comparison = (Comparison)expression).operator() == Comparison.Operator.EQUAL) {
                    expressionBuilder.put((Object)comparison.left(), (Object)comparison);
                    continue;
                }
                if (!(expression instanceof In)) continue;
                In in = (In)expression;
                expressionBuilder.put((Object)in.value(), (Object)in);
            }
            return expressionBuilder.build().asMap();
        }
    }
}

