/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DereferencePushdown;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PushDownDereferencesThroughLimit
implements Rule<ProjectNode> {
    private static final Capture<LimitNode> CHILD = Capture.newCapture();

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(Patterns.limit().capturedAs(CHILD)));
    }

    @Override
    public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
        LimitNode limitNode = (LimitNode)captures.get(CHILD);
        Set dereferences = DereferencePushdown.extractRowSubscripts(projectNode.getAssignments().getExpressions(), false);
        ImmutableSet excludedSymbols = ImmutableSet.builder().addAll((Iterable)limitNode.getTiesResolvingScheme().map(OrderingScheme::orderBy).orElse((List)ImmutableList.of())).addAll(limitNode.getPreSortedInputs()).build();
        if ((dereferences = (Set)dereferences.stream().filter(arg_0 -> PushDownDereferencesThroughLimit.lambda$apply$0((Set)excludedSymbols, arg_0)).collect(ImmutableSet.toImmutableSet())).isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments dereferenceAssignments = Assignments.of(dereferences, context.getSymbolAllocator());
        Map mappings = (Map)HashBiMap.create(dereferenceAssignments.getMap()).inverse().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
        Assignments newAssignments = projectNode.getAssignments().rewrite(expression -> ExpressionNodeInliner.replaceExpression(expression, mappings));
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), limitNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new ProjectNode(context.getIdAllocator().getNextId(), limitNode.getSource(), Assignments.builder().putIdentities(limitNode.getSource().getOutputSymbols()).putAll(dereferenceAssignments).build()))), newAssignments));
    }

    private static /* synthetic */ boolean lambda$apply$0(Set excludedSymbols, FieldReference expression) {
        return !excludedSymbols.contains(DereferencePushdown.getBase(expression));
    }
}

