/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.IrExpressionOptimizer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.planner.iterative.rule.ExtractCommonPredicatesExpressionRewriter;
import io.trino.sql.planner.iterative.rule.NormalizeOrExpressionRewriter;
import io.trino.sql.planner.iterative.rule.PushDownNegationsExpressionRewriter;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SimplifyExpressions
extends ExpressionRewriteRuleSet {
    public static Expression rewrite(Expression expression, Session session, IrExpressionOptimizer optimizer) {
        if (expression instanceof Reference) {
            return expression;
        }
        expression = PushDownNegationsExpressionRewriter.pushDownNegations(expression);
        expression = ExtractCommonPredicatesExpressionRewriter.extractCommonPredicates(expression);
        expression = NormalizeOrExpressionRewriter.normalizeOrExpression(expression);
        return optimizer.process(expression, session, (Map<Symbol, Expression>)ImmutableMap.of()).orElse(expression);
    }

    public SimplifyExpressions(PlannerContext plannerContext) {
        super(SimplifyExpressions.createRewrite(plannerContext));
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite(), this.patternRecognitionExpressionRewrite());
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(PlannerContext plannerContext) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        return (expression, context) -> SimplifyExpressions.rewrite(expression, context.getSession(), IrExpressionOptimizer.newOptimizer(plannerContext));
    }
}

