/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AdaptivePlanNode
extends PlanNode {
    private final PlanNode initialPlan;
    private final Set<Symbol> initialSymbols;
    private final PlanNode currentPlan;

    @JsonCreator
    public AdaptivePlanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="initialPlan") PlanNode initialPlan, @JsonProperty(value="initialSymbols") Set<Symbol> initialSymbols, @JsonProperty(value="currentPlan") PlanNode currentPlan) {
        super(id);
        this.initialPlan = Objects.requireNonNull(initialPlan, "initialPlan is null");
        this.initialSymbols = ImmutableSet.copyOf(initialSymbols);
        this.currentPlan = Objects.requireNonNull(currentPlan, "currentPlan is null");
    }

    @JsonProperty
    public PlanNode getInitialPlan() {
        return this.initialPlan;
    }

    @JsonProperty
    public Set<Symbol> getInitialSymbols() {
        return this.initialSymbols;
    }

    @JsonProperty
    public PlanNode getCurrentPlan() {
        return this.currentPlan;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.currentPlan);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.currentPlan.getOutputSymbols();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new AdaptivePlanNode(this.getId(), this.initialPlan, this.initialSymbols, (PlanNode)Iterables.getOnlyElement(newChildren));
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAdaptivePlanNode(this, context);
    }
}

