/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class TopNRankingNode
extends PlanNode {
    private final PlanNode source;
    private final DataOrganizationSpecification specification;
    private final RankingType rankingType;
    private final Symbol rankingSymbol;
    private final int maxRankingPerPartition;
    private final boolean partial;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public TopNRankingNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="specification") DataOrganizationSpecification specification, @JsonProperty(value="rankingType") RankingType rankingType, @JsonProperty(value="rankingSymbol") Symbol rankingSymbol, @JsonProperty(value="maxRankingPerPartition") int maxRankingPerPartition, @JsonProperty(value="partial") boolean partial, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(specification, "specification is null");
        Preconditions.checkArgument((boolean)specification.orderingScheme().isPresent(), (Object)"specification orderingScheme is absent");
        Objects.requireNonNull(rankingType, "rankingType is null");
        Objects.requireNonNull(rankingSymbol, "rankingSymbol is null");
        Preconditions.checkArgument((maxRankingPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRankingPerPartition must be > 0");
        Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        this.source = source;
        this.specification = specification;
        this.rankingType = rankingType;
        this.rankingSymbol = rankingSymbol;
        this.maxRankingPerPartition = maxRankingPerPartition;
        this.partial = partial;
        this.hashSymbol = hashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        if (!this.partial) {
            return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), (Iterable)ImmutableList.of((Object)this.rankingSymbol)));
        }
        return ImmutableList.copyOf(this.source.getOutputSymbols());
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public DataOrganizationSpecification getSpecification() {
        return this.specification;
    }

    public List<Symbol> getPartitionBy() {
        return this.specification.partitionBy();
    }

    public OrderingScheme getOrderingScheme() {
        return this.specification.orderingScheme().get();
    }

    @JsonProperty
    public RankingType getRankingType() {
        return this.rankingType;
    }

    @JsonProperty
    public Symbol getRankingSymbol() {
        return this.rankingSymbol;
    }

    @JsonProperty
    public int getMaxRankingPerPartition() {
        return this.maxRankingPerPartition;
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTopNRanking(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TopNRankingNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.specification, this.rankingType, this.rankingSymbol, this.maxRankingPerPartition, this.partial, this.hashSymbol);
    }

    public static enum RankingType {
        ROW_NUMBER,
        RANK,
        DENSE_RANK;

    }
}

