/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class UnnestNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> replicateSymbols;
    private final List<Mapping> mappings;
    private final Optional<Symbol> ordinalitySymbol;
    private final JoinType joinType;

    @JsonCreator
    public UnnestNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="replicateSymbols") List<Symbol> replicateSymbols, @JsonProperty(value="mappings") List<Mapping> mappings, @JsonProperty(value="ordinalitySymbol") Optional<Symbol> ordinalitySymbol, @JsonProperty(value="joinType") JoinType joinType) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.replicateSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateSymbols, "replicateSymbols is null"));
        Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(replicateSymbols), (Object)"Source does not contain all replicateSymbols");
        Objects.requireNonNull(mappings, "mappings is null");
        Preconditions.checkArgument((!mappings.isEmpty() ? 1 : 0) != 0, (Object)"mappings is empty");
        this.mappings = ImmutableList.copyOf(mappings);
        this.ordinalitySymbol = Objects.requireNonNull(ordinalitySymbol, "ordinalitySymbol is null");
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder().addAll(this.replicateSymbols).addAll((Iterable)this.mappings.stream().map(Mapping::getOutputs).flatMap(Collection::stream).collect(ImmutableList.toImmutableList()));
        this.ordinalitySymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)outputSymbolsBuilder).add(arg_0));
        return outputSymbolsBuilder.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getReplicateSymbols() {
        return this.replicateSymbols;
    }

    @JsonProperty
    public List<Mapping> getMappings() {
        return this.mappings;
    }

    @JsonProperty
    public Optional<Symbol> getOrdinalitySymbol() {
        return this.ordinalitySymbol;
    }

    @JsonProperty
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitUnnest(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new UnnestNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.replicateSymbols, this.mappings, this.ordinalitySymbol, this.joinType);
    }

    public static class Mapping {
        private final Symbol input;
        private final List<Symbol> outputs;

        @JsonCreator
        public Mapping(@JsonProperty(value="input") Symbol input, @JsonProperty(value="outputs") List<Symbol> outputs) {
            this.input = Objects.requireNonNull(input, "input is null");
            Objects.requireNonNull(outputs, "outputs is null");
            this.outputs = ImmutableList.copyOf(outputs);
        }

        @JsonProperty
        public Symbol getInput() {
            return this.input;
        }

        @JsonProperty
        public List<Symbol> getOutputs() {
            return this.outputs;
        }
    }
}

