/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.spi.Mergeable;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.planprinter.BasicOperatorStats;
import io.trino.util.MoreMaps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PlanNodeStats
implements Mergeable<PlanNodeStats> {
    private final PlanNodeId planNodeId;
    private final Duration planNodeScheduledTime;
    private final Duration planNodeCpuTime;
    private final Duration planNodeBlockedTime;
    private final long planNodeInputPositions;
    private final DataSize planNodeInputDataSize;
    private final DataSize planNodePhysicalInputDataSize;
    private final Duration planNodePhysicalInputReadTime;
    private final long planNodeOutputPositions;
    private final DataSize planNodeOutputDataSize;
    private final DataSize planNodeSpilledDataSize;
    protected final Map<String, BasicOperatorStats> operatorStats;

    PlanNodeStats(PlanNodeId planNodeId, Duration planNodeScheduledTime, Duration planNodeCpuTime, Duration planNodeBlockedTime, long planNodeInputPositions, DataSize planNodeInputDataSize, DataSize planNodePhysicalInputDataSize, Duration planNodePhysicalInputReadTime, long planNodeOutputPositions, DataSize planNodeOutputDataSize, DataSize planNodeSpilledDataSize, Map<String, BasicOperatorStats> operatorStats) {
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.planNodeScheduledTime = Objects.requireNonNull(planNodeScheduledTime, "planNodeScheduledTime is null");
        this.planNodeCpuTime = Objects.requireNonNull(planNodeCpuTime, "planNodeCpuTime is null");
        this.planNodeBlockedTime = Objects.requireNonNull(planNodeBlockedTime, "planNodeBlockedTime is null");
        this.planNodeInputPositions = planNodeInputPositions;
        this.planNodePhysicalInputDataSize = planNodePhysicalInputDataSize;
        this.planNodePhysicalInputReadTime = planNodePhysicalInputReadTime;
        this.planNodeInputDataSize = planNodeInputDataSize;
        this.planNodeOutputPositions = planNodeOutputPositions;
        this.planNodeOutputDataSize = planNodeOutputDataSize;
        this.planNodeSpilledDataSize = Objects.requireNonNull(planNodeSpilledDataSize, "planNodeSpilledDataSize is null");
        this.operatorStats = ImmutableMap.copyOf(Objects.requireNonNull(operatorStats, "operatorStats is null"));
    }

    private static double computedStdDev(double sumSquared, double sum, long n) {
        double average = sum / (double)n;
        double variance = (sumSquared - 2.0 * sum * average + average * average * (double)n) / (double)n;
        return Math.sqrt(Double.max(variance, 0.0));
    }

    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    public Duration getPlanNodeScheduledTime() {
        return this.planNodeScheduledTime;
    }

    public Duration getPlanNodeCpuTime() {
        return this.planNodeCpuTime;
    }

    public Duration getPlanNodeBlockedTime() {
        return this.planNodeBlockedTime;
    }

    public Set<String> getOperatorTypes() {
        return this.operatorStats.keySet();
    }

    public long getPlanNodeInputPositions() {
        return this.planNodeInputPositions;
    }

    public DataSize getPlanNodeInputDataSize() {
        return this.planNodeInputDataSize;
    }

    public DataSize getPlanNodePhysicalInputDataSize() {
        return this.planNodePhysicalInputDataSize;
    }

    public Duration getPlanNodePhysicalInputReadTime() {
        return this.planNodePhysicalInputReadTime;
    }

    public long getPlanNodeOutputPositions() {
        return this.planNodeOutputPositions;
    }

    public DataSize getPlanNodeOutputDataSize() {
        return this.planNodeOutputDataSize;
    }

    public DataSize getPlanNodeSpilledDataSize() {
        return this.planNodeSpilledDataSize;
    }

    public Map<String, Double> getOperatorInputPositionsAverages() {
        return (Map)this.operatorStats.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (double)((BasicOperatorStats)entry.getValue()).getInputPositions() / (double)this.operatorStats.get(entry.getKey()).getTotalDrivers()));
    }

    public Map<String, Double> getOperatorInputPositionsStdDevs() {
        return (Map)this.operatorStats.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> PlanNodeStats.computedStdDev(((BasicOperatorStats)entry.getValue()).getSumSquaredInputPositions(), ((BasicOperatorStats)entry.getValue()).getInputPositions(), ((BasicOperatorStats)entry.getValue()).getTotalDrivers())));
    }

    public Map<String, BasicOperatorStats> getOperatorStats() {
        return this.operatorStats;
    }

    public PlanNodeStats mergeWith(PlanNodeStats other) {
        Preconditions.checkArgument((boolean)this.planNodeId.equals(other.getPlanNodeId()), (String)"planNodeIds do not match. %s != %s", (Object)this.planNodeId, (Object)other.getPlanNodeId());
        long planNodeInputPositions = this.planNodeInputPositions + other.planNodeInputPositions;
        DataSize planNodeInputDataSize = DataSize.succinctBytes((long)(this.planNodeInputDataSize.toBytes() + other.planNodeInputDataSize.toBytes()));
        long planNodeOutputPositions = this.planNodeOutputPositions + other.planNodeOutputPositions;
        DataSize planNodeOutputDataSize = DataSize.succinctBytes((long)(this.planNodeOutputDataSize.toBytes() + other.planNodeOutputDataSize.toBytes()));
        Map<String, BasicOperatorStats> operatorStats = MoreMaps.mergeMaps(this.operatorStats, other.operatorStats, BasicOperatorStats::merge);
        return new PlanNodeStats(this.planNodeId, new Duration((double)(this.planNodeScheduledTime.toMillis() + other.getPlanNodeScheduledTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeCpuTime.toMillis() + other.getPlanNodeCpuTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeBlockedTime.toMillis() + other.getPlanNodeBlockedTime().toMillis()), TimeUnit.MILLISECONDS), planNodeInputPositions, planNodeInputDataSize, DataSize.succinctBytes((long)(this.planNodePhysicalInputDataSize.toBytes() + other.planNodePhysicalInputDataSize.toBytes())), new Duration((double)(this.planNodePhysicalInputReadTime.toMillis() + other.getPlanNodePhysicalInputReadTime().toMillis()), TimeUnit.MILLISECONDS), planNodeOutputPositions, planNodeOutputDataSize, DataSize.succinctBytes((long)(this.planNodeSpilledDataSize.toBytes() + other.planNodeSpilledDataSize.toBytes())), operatorStats);
    }

    public PlanNodeStats mergeWith(List<PlanNodeStats> others) {
        long planNodeInputPositions = this.planNodeInputPositions;
        long planNodeOutputPositions = this.planNodeOutputPositions;
        long planNodeInputDataSizeBytes = this.planNodeInputDataSize.toBytes();
        long planNodeOutputDataSizeBytes = this.planNodeOutputDataSize.toBytes();
        long planNodePhysicalInputDataSizeBytes = this.planNodePhysicalInputDataSize.toBytes();
        long planNodeSpilledDataSizeBytes = this.planNodeSpilledDataSize.toBytes();
        long planNodeScheduledTimeMillis = this.planNodeScheduledTime.toMillis();
        long planNodeCpuTimeMillis = this.planNodeCpuTime.toMillis();
        long planNodeBlockedTimeMillis = this.planNodeBlockedTime.toMillis();
        double planNodePhysicalInputReadNanos = this.planNodePhysicalInputReadTime.getValue(TimeUnit.NANOSECONDS);
        ArrayListMultimap groupedOperatorStats = ArrayListMultimap.create();
        for (Map.Entry<String, BasicOperatorStats> entry : this.operatorStats.entrySet()) {
            groupedOperatorStats.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        for (PlanNodeStats other : others) {
            Preconditions.checkArgument((boolean)this.planNodeId.equals(other.getPlanNodeId()), (String)"planNodeIds do not match. %s != %s", (Object)this.planNodeId, (Object)other.getPlanNodeId());
            planNodeInputPositions += other.planNodeInputPositions;
            planNodeOutputPositions += other.planNodeOutputPositions;
            planNodeScheduledTimeMillis += other.planNodeScheduledTime.toMillis();
            planNodeCpuTimeMillis += other.planNodeCpuTime.toMillis();
            planNodeBlockedTimeMillis += other.planNodeBlockedTime.toMillis();
            planNodePhysicalInputReadNanos += other.planNodePhysicalInputReadTime.getValue(TimeUnit.NANOSECONDS);
            planNodePhysicalInputDataSizeBytes += other.planNodePhysicalInputDataSize.toBytes();
            planNodeInputDataSizeBytes += other.planNodeInputDataSize.toBytes();
            planNodeOutputDataSizeBytes += other.planNodeOutputDataSize.toBytes();
            planNodeSpilledDataSizeBytes += other.planNodeSpilledDataSize.toBytes();
            for (Map.Entry<String, BasicOperatorStats> entry : other.operatorStats.entrySet()) {
                groupedOperatorStats.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        ImmutableMap.Builder mergedOperatorStatsBuilder = ImmutableMap.builder();
        for (String key : groupedOperatorStats.keySet()) {
            mergedOperatorStatsBuilder.put((Object)key, (Object)BasicOperatorStats.merge(groupedOperatorStats.get((Object)key)));
        }
        return new PlanNodeStats(this.planNodeId, new Duration((double)planNodeScheduledTimeMillis, TimeUnit.MILLISECONDS), new Duration((double)planNodeCpuTimeMillis, TimeUnit.MILLISECONDS), new Duration((double)planNodeBlockedTimeMillis, TimeUnit.MILLISECONDS), planNodeInputPositions, DataSize.succinctBytes((long)planNodeInputDataSizeBytes), DataSize.succinctBytes((long)planNodePhysicalInputDataSizeBytes), new Duration(planNodePhysicalInputReadNanos, TimeUnit.NANOSECONDS), planNodeOutputPositions, DataSize.succinctBytes((long)planNodeOutputDataSizeBytes), DataSize.succinctBytes((long)planNodeSpilledDataSizeBytes), (Map<String, BasicOperatorStats>)mergedOperatorStatsBuilder.buildOrThrow());
    }
}

