/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.operator.window.pattern.LogicalIndexNavigation;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LogicalIndexPointer {
    private final Set<IrLabel> labels;
    private final boolean last;
    private final boolean running;
    private final int logicalOffset;
    private final int physicalOffset;

    @JsonCreator
    public LogicalIndexPointer(Set<IrLabel> labels, boolean last, boolean running, int logicalOffset, int physicalOffset) {
        this.labels = Objects.requireNonNull(labels, "labels is null");
        this.last = last;
        this.running = running;
        Preconditions.checkArgument((logicalOffset >= 0 ? 1 : 0) != 0, (String)"logical offset must be >= 0, actual: %s", (int)logicalOffset);
        this.logicalOffset = logicalOffset;
        this.physicalOffset = physicalOffset;
    }

    @JsonProperty
    public Set<IrLabel> getLabels() {
        return this.labels;
    }

    @JsonProperty
    public boolean isLast() {
        return this.last;
    }

    @JsonProperty
    public boolean isRunning() {
        return this.running;
    }

    @JsonProperty
    public int getLogicalOffset() {
        return this.logicalOffset;
    }

    @JsonProperty
    public int getPhysicalOffset() {
        return this.physicalOffset;
    }

    public LogicalIndexNavigation toLogicalIndexNavigation(Map<IrLabel, Integer> mapping) {
        return new LogicalIndexNavigation((Set)this.labels.stream().map(mapping::get).collect(ImmutableSet.toImmutableSet()), this.last, this.running, this.logicalOffset, this.physicalOffset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalIndexPointer that = (LogicalIndexPointer)o;
        return this.last == that.last && this.running == that.running && this.logicalOffset == that.logicalOffset && this.physicalOffset == that.physicalOffset && this.labels.equals(that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.last, this.running, this.logicalOffset, this.physicalOffset);
    }
}

