/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import io.trino.Session;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.planner.sanity.DynamicFiltersChecker;
import io.trino.sql.planner.sanity.NoDuplicatePlanNodeIdsChecker;
import io.trino.sql.planner.sanity.TableExecuteStructureValidator;
import io.trino.sql.planner.sanity.TableScanValidator;
import io.trino.sql.planner.sanity.TypeValidator;
import io.trino.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import io.trino.sql.planner.sanity.ValidateDependenciesChecker;
import io.trino.sql.planner.sanity.ValidateScaledWritersUsage;
import io.trino.sql.planner.sanity.ValidateStreamingAggregations;
import io.trino.sql.planner.sanity.VerifyNoFilteredAggregations;
import io.trino.sql.planner.sanity.VerifyOnlyOneOutputNode;
import io.trino.sql.planner.sanity.VerifyUseConnectorNodePartitioningSet;

public final class PlanSanityChecker {
    public static final PlanSanityChecker DISTRIBUTED_PLAN_SANITY_CHECKER = new PlanSanityChecker(false);
    private final Multimap<Stage, Checker> checkers;

    public PlanSanityChecker(boolean forceSingleNode) {
        this.checkers = ImmutableListMultimap.builder().putAll((Object)Stage.INTERMEDIATE, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new VerifyOnlyOneOutputNode()}).putAll((Object)Stage.FINAL, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new VerifyOnlyOneOutputNode(), new VerifyNoFilteredAggregations(), new VerifyUseConnectorNodePartitioningSet(), new ValidateAggregationsWithDefaultValues(forceSingleNode), new ValidateScaledWritersUsage(), new ValidateStreamingAggregations(), new DynamicFiltersChecker(), new TableScanValidator(), new TableExecuteStructureValidator()}).putAll((Object)Stage.AFTER_ADAPTIVE_PLANNING, (Object[])new Checker[]{new ValidateDependenciesChecker(), new NoDuplicatePlanNodeIdsChecker(), new TypeValidator(), new VerifyOnlyOneOutputNode(), new VerifyNoFilteredAggregations(), new VerifyUseConnectorNodePartitioningSet(), new ValidateScaledWritersUsage(), new TableScanValidator(), new TableExecuteStructureValidator()}).build();
    }

    public void validateFinalPlan(PlanNode planNode, Session session, PlannerContext plannerContext, WarningCollector warningCollector) {
        this.validate(Stage.FINAL, planNode, session, plannerContext, warningCollector);
    }

    public void validateIntermediatePlan(PlanNode planNode, Session session, PlannerContext plannerContext, WarningCollector warningCollector) {
        this.validate(Stage.INTERMEDIATE, planNode, session, plannerContext, warningCollector);
    }

    public void validateAdaptivePlan(PlanNode planNode, Session session, PlannerContext plannerContext, WarningCollector warningCollector) {
        this.validate(Stage.AFTER_ADAPTIVE_PLANNING, planNode, session, plannerContext, warningCollector);
    }

    private void validate(Stage stage, PlanNode planNode, Session session, PlannerContext plannerContext, WarningCollector warningCollector) {
        try {
            this.checkers.get((Object)stage).forEach(checker -> checker.validate(planNode, session, plannerContext, warningCollector));
        }
        catch (RuntimeException e) {
            try {
                int nestLevel = 4;
                String explain = PlanPrinter.textLogicalPlan(planNode, plannerContext.getMetadata(), plannerContext.getFunctionManager(), StatsAndCosts.empty(), session, nestLevel, false);
                e.addSuppressed(new Exception("Current plan:\n" + explain));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
    }

    private static enum Stage {
        INTERMEDIATE,
        FINAL,
        AFTER_ADAPTIVE_PLANNING;

    }

    public static interface Checker {
        public void validate(PlanNode var1, Session var2, PlannerContext var3, WarningCollector var4);
    }
}

