/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;
import java.util.Arrays;
import java.util.List;

public final class Expressions {
    private Expressions() {
    }

    public static ConstantExpression constant(Object value, Type type) {
        return new ConstantExpression(value, type);
    }

    public static ConstantExpression constantNull(Type type) {
        return new ConstantExpression(null, type);
    }

    public static CallExpression call(ResolvedFunction resolvedFunction, RowExpression ... arguments) {
        return new CallExpression(resolvedFunction, Arrays.asList(arguments));
    }

    public static CallExpression call(ResolvedFunction resolvedFunction, List<RowExpression> arguments) {
        return new CallExpression(resolvedFunction, arguments);
    }

    public static InputReferenceExpression field(int field, Type type) {
        return new InputReferenceExpression(field, type);
    }

    public static List<RowExpression> subExpressions(Iterable<RowExpression> expressions) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        for (RowExpression expression : expressions) {
            expression.accept(new RowExpressionVisitor<Void, Void>(){

                @Override
                public Void visitCall(CallExpression call, Void context) {
                    builder.add((Object)call);
                    for (RowExpression argument : call.arguments()) {
                        argument.accept(this, context);
                    }
                    return null;
                }

                @Override
                public Void visitSpecialForm(SpecialForm specialForm, Void context) {
                    builder.add((Object)specialForm);
                    for (RowExpression argument : specialForm.arguments()) {
                        argument.accept(this, context);
                    }
                    return null;
                }

                @Override
                public Void visitInputReference(InputReferenceExpression reference, Void context) {
                    builder.add((Object)reference);
                    return null;
                }

                @Override
                public Void visitConstant(ConstantExpression literal, Void context) {
                    builder.add((Object)literal);
                    return null;
                }

                @Override
                public Void visitLambda(LambdaDefinitionExpression lambda, Void context) {
                    builder.add((Object)lambda);
                    lambda.body().accept(this, context);
                    return null;
                }

                @Override
                public Void visitVariableReference(VariableReferenceExpression reference, Void context) {
                    builder.add((Object)reference);
                    return null;
                }
            }, null);
        }
        return builder.build();
    }
}

