/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.type.FunctionType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public record LambdaDefinitionExpression(List<Symbol> arguments, RowExpression body) implements RowExpression
{
    public LambdaDefinitionExpression {
        arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
        Objects.requireNonNull(body, "body is null");
    }

    @Override
    public Type type() {
        return new FunctionType(this.arguments.stream().map(Symbol::type).toList(), this.body.type());
    }

    @Override
    public String toString() {
        return "(" + this.arguments.stream().map(Symbol::name).collect(Collectors.joining(", ")) + ") -> " + String.valueOf(this.body);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLambda(this, context);
    }
}

