/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.authentication;

import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.trino.plugin.base.authentication.KerberosConfiguration;
import java.security.Principal;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosAuthentication {
    private static final Logger log = Logger.get(KerberosAuthentication.class);
    private final KerberosPrincipal principal;
    private final Configuration configuration;

    public KerberosAuthentication(KerberosConfiguration kerberosConfiguration) {
        Objects.requireNonNull(kerberosConfiguration, "kerberosConfiguration is null");
        this.principal = kerberosConfiguration.kerberosPrincipal();
        if (log.isDebugEnabled()) {
            kerberosConfiguration = kerberosConfiguration.withDebug();
        }
        this.configuration = kerberosConfiguration.getConfiguration();
    }

    public Subject getSubject() {
        Subject subject = new Subject(false, (Set<? extends Principal>)ImmutableSet.of((Object)this.principal), Collections.emptySet(), Collections.emptySet());
        try {
            LoginContext loginContext = new LoginContext("", subject, null, this.configuration);
            loginContext.login();
            return loginContext.getSubject();
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptLogin(Subject subject) {
        try {
            Set<Object> set = subject.getPrivateCredentials();
            synchronized (set) {
                subject.getPrivateCredentials().clear();
                LoginContext loginContext = new LoginContext("", subject, null, this.configuration);
                loginContext.login();
            }
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }
}

