/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.projection;

import com.google.common.base.Verify;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.expression.ConnectorExpression;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface ProjectFunctionRule<ProjectionResult, ExpressionResult> {
    public Pattern<? extends ConnectorExpression> getPattern();

    default public boolean isEnabled(ConnectorSession session) {
        return true;
    }

    public Optional<ProjectionResult> rewrite(ConnectorTableHandle var1, ConnectorExpression var2, Captures var3, RewriteContext<ExpressionResult> var4);

    public static interface RewriteContext<ExpressionResult> {
        default public ColumnHandle getAssignment(String name) {
            Objects.requireNonNull(name, "name is null");
            ColumnHandle columnHandle = this.getAssignments().get(name);
            Verify.verifyNotNull((Object)columnHandle, (String)"No assignment for %s", (Object[])new Object[]{name});
            return columnHandle;
        }

        public Map<String, ColumnHandle> getAssignments();

        public ConnectorSession getSession();

        public Optional<ExpressionResult> rewriteExpression(ConnectorExpression var1);
    }
}

