/*
 * Decompiled with CFR 0.152.
 */
package io.trino.re2j;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.re2j.Pattern;
import io.trino.re2j.RE2;
import io.trino.re2j.SliceUtils;

public final class Matcher {
    private final Pattern pattern;
    private final int[] groups;
    private final int groupCount;
    private Slice input;
    private int appendPos;
    private boolean hasMatch;
    private boolean hasGroups;
    private RE2.Anchor anchorFlag;

    private Matcher(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        this.pattern = pattern;
        RE2 re2 = pattern.re2();
        this.groupCount = re2.numberOfCapturingGroups();
        this.groups = new int[2 + 2 * this.groupCount];
    }

    Matcher(Pattern pattern, Slice input) {
        this(pattern);
        this.reset(input);
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Matcher reset() {
        this.appendPos = 0;
        this.hasMatch = false;
        this.hasGroups = false;
        return this;
    }

    public Matcher reset(Slice input) {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        this.reset();
        this.input = input;
        return this;
    }

    public int start() {
        return this.start(0);
    }

    public int end() {
        return this.end(0);
    }

    public int start(int group) {
        this.loadGroup(group);
        return this.groups[2 * group];
    }

    public int end(int group) {
        this.loadGroup(group);
        return this.groups[2 * group + 1];
    }

    public Slice group() {
        return this.group(0);
    }

    public Slice group(int group) {
        int start = this.start(group);
        int end = this.end(group);
        if (start < 0 && end < 0) {
            return null;
        }
        return this.input.slice(start, end - start);
    }

    public int groupCount() {
        return this.groupCount;
    }

    private void loadGroup(int group) {
        boolean ok;
        if (group < 0 || group > this.groupCount) {
            throw new IndexOutOfBoundsException("Group index out of bounds: " + group);
        }
        if (!this.hasMatch) {
            throw new IllegalStateException("perhaps no match attempted");
        }
        if (group == 0 || this.hasGroups) {
            return;
        }
        int end = this.groups[1] + 1;
        if (end > this.input.length()) {
            end = this.input.length();
        }
        if (!(ok = this.pattern.re2().match(this.input.slice(0, end), this.groups[0], this.anchorFlag, this.groups, 1 + this.groupCount))) {
            throw new IllegalStateException("inconsistency in matching group data");
        }
        this.hasGroups = true;
    }

    public boolean matches() {
        return this.genMatch(0, RE2.Anchor.ANCHOR_BOTH);
    }

    public boolean lookingAt() {
        return this.genMatch(0, RE2.Anchor.ANCHOR_START);
    }

    public boolean find() {
        int start = 0;
        if (this.hasMatch) {
            start = this.groups[1];
            if (this.groups[0] == this.groups[1]) {
                ++start;
            }
        }
        return this.genMatch(start, RE2.Anchor.UNANCHORED);
    }

    public boolean find(int start) {
        if (start < 0 || start > this.input.length()) {
            throw new IndexOutOfBoundsException("start index out of bounds: " + start);
        }
        this.reset();
        return this.genMatch(start, RE2.Anchor.UNANCHORED);
    }

    private boolean genMatch(int startByte, RE2.Anchor anchor) {
        boolean ok = this.pattern.re2().match(this.input, startByte, anchor, this.groups, 1);
        if (!ok) {
            return false;
        }
        this.hasMatch = true;
        this.hasGroups = false;
        this.anchorFlag = anchor;
        return true;
    }

    Slice substring(int start, int end) {
        return this.input.slice(start, end - start);
    }

    int inputLength() {
        return this.input.length();
    }

    public Matcher appendReplacement(SliceOutput so, Slice replacement) {
        int s = this.start();
        int e = this.end();
        if (this.appendPos < s) {
            so.writeBytes(this.input, this.appendPos, s - this.appendPos);
        }
        this.appendPos = e;
        SliceUtils.appendReplacement(so, replacement, this);
        return this;
    }

    public SliceOutput appendTail(SliceOutput so) {
        so.writeBytes(this.input, this.appendPos, this.input.length() - this.appendPos);
        return so;
    }

    public Slice replaceAll(Slice replacement) {
        return this.replace(replacement, true);
    }

    public Slice replaceFirst(Slice replacement) {
        return this.replace(replacement, false);
    }

    private Slice replace(Slice replacement, boolean all) {
        this.reset();
        DynamicSliceOutput so = new DynamicSliceOutput(this.input.length());
        while (this.find()) {
            this.appendReplacement((SliceOutput)so, replacement);
            if (all) continue;
        }
        this.appendTail((SliceOutput)so);
        return so.slice();
    }
}

