/*
 * Decompiled with CFR 0.152.
 */
package io.trino.re2j;

import io.airlift.slice.Slice;
import io.trino.re2j.Unicode;

abstract class Utils {
    static final int[] EMPTY_INTS = new int[0];
    private static final String METACHARACTERS = "\\.+*?()|[]{}^$";
    static final int EMPTY_BEGIN_LINE = 1;
    static final int EMPTY_END_LINE = 2;
    static final int EMPTY_BEGIN_TEXT = 4;
    static final int EMPTY_END_TEXT = 8;
    static final int EMPTY_WORD_BOUNDARY = 16;
    static final int EMPTY_NO_WORD_BOUNDARY = 32;
    static final int EMPTY_ALL = -1;

    static boolean isalnum(int c) {
        return 48 <= c && c <= 57 || 65 <= c && c <= 90 || 97 <= c && c <= 122;
    }

    static int unhex(int c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 102) {
            return c - 97 + 10;
        }
        if (65 <= c && c <= 70) {
            return c - 65 + 10;
        }
        return -1;
    }

    static void escapeRune(StringBuilder out, int rune) {
        if (Unicode.isPrint(rune)) {
            if (METACHARACTERS.indexOf((char)rune) >= 0) {
                out.append('\\');
            }
            out.appendCodePoint(rune);
            return;
        }
        switch (rune) {
            case 34: {
                out.append("\\\"");
                break;
            }
            case 92: {
                out.append("\\\\");
                break;
            }
            case 9: {
                out.append("\\t");
                break;
            }
            case 10: {
                out.append("\\n");
                break;
            }
            case 13: {
                out.append("\\r");
                break;
            }
            case 8: {
                out.append("\\b");
                break;
            }
            case 12: {
                out.append("\\f");
                break;
            }
            default: {
                String s = Integer.toHexString(rune);
                if (rune < 256) {
                    out.append("\\x");
                    if (s.length() == 1) {
                        out.append('0');
                    }
                    out.append(s);
                    break;
                }
                out.append("\\x{").append(s).append('}');
                break;
            }
        }
    }

    static int[] stringToRunes(String str) {
        int rune;
        int charlen = str.length();
        int runelen = str.codePointCount(0, charlen);
        int[] runes = new int[runelen];
        int r = 0;
        for (int c = 0; c < charlen; c += Character.charCount(rune)) {
            rune = str.codePointAt(c);
            runes[r++] = rune;
        }
        return runes;
    }

    static String runeToString(int r) {
        char c = (char)r;
        return r == c ? String.valueOf(c) : new String(Character.toChars(c));
    }

    static int[] subarray(int[] array, int start, int end) {
        int[] r = new int[end - start];
        for (int i = start; i < end; ++i) {
            r[i - start] = array[i];
        }
        return r;
    }

    static byte[] subarray(byte[] array, int start, int end) {
        byte[] r = new byte[end - start];
        for (int i = start; i < end; ++i) {
            r[i - start] = array[i];
        }
        return r;
    }

    static int indexOf(Slice source, Slice target, int fromIndex) {
        if (fromIndex >= source.length()) {
            return target.length() == 0 ? source.length() : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (target.length() == 0) {
            return fromIndex;
        }
        byte first = target.getByte(0);
        int max = source.length() - target.length();
        for (int i = fromIndex; i <= max; ++i) {
            if (source.getByte(i) != first) {
                while (++i <= max && source.getByte(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length() - 1;
            int k = 1;
            while (j < end && source.getByte(j) == target.getByte(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    static boolean isWordByte(byte b) {
        return 65 <= b && b <= 90 || 97 <= b && b <= 122 || 48 <= b && b <= 57 || b == 95;
    }

    static boolean isRuneStart(byte b) {
        return (b & 0xC0) != 128;
    }

    static int emptyOpContext(byte b1, byte b2) {
        int op = 0;
        if (b1 == -1) {
            op |= 5;
        }
        if (b1 == 10) {
            op |= 1;
        }
        if (b2 == -1) {
            op |= 0xA;
        }
        if (b2 == 10) {
            op |= 2;
        }
        op = Utils.isWordByte(b1) != Utils.isWordByte(b2) ? (op |= 0x10) : (op |= 0x20);
        return op;
    }

    static boolean arrayFirstElementsEqual(int[] a, int[] a2, int length) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length < length || a2.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private Utils() {
    }
}

