/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.openmetrics.types;

import com.google.common.collect.ImmutableMap;
import io.airlift.openmetrics.types.Metric;
import io.airlift.stats.TimeDistribution;
import java.util.Map;
import java.util.Objects;

public record Summary(String metricName, Long count, Double sum, Double created, Map<Double, Double> quantiles, Map<String, String> labels, String help) implements Metric
{
    public Summary(String metricName, Long count, Double sum, Double created, Map<Double, Double> quantiles, Map<String, String> labels, String help) {
        this.metricName = Objects.requireNonNull(metricName, "metricName is null");
        this.count = count;
        this.sum = sum;
        this.created = created;
        this.quantiles = quantiles;
        this.labels = labels;
        this.help = help;
    }

    public static Summary from(String metricName, TimeDistribution timeDistribution, Map<String, String> labels, String help) {
        return new Summary(metricName, (long)timeDistribution.getCount(), timeDistribution.getAvg() * timeDistribution.getCount(), null, (Map<Double, Double>)ImmutableMap.builder().put((Object)0.5, (Object)timeDistribution.getP50()).put((Object)0.75, (Object)timeDistribution.getP75()).put((Object)0.9, (Object)timeDistribution.getP90()).put((Object)0.95, (Object)timeDistribution.getP95()).put((Object)0.99, (Object)timeDistribution.getP99()).build(), labels, help);
    }

    @Override
    public String getMetricExposition() {
        StringBuilder stringBuilder = new StringBuilder("# TYPE %s %s\n".formatted(this.metricName, "summary"));
        if (this.help != null && !this.help.isEmpty()) {
            stringBuilder.append("# HELP %s %s\n".formatted(this.metricName, this.help));
        }
        if (this.count != null) {
            stringBuilder.append("%s %s\n".formatted(Metric.formatNameWithLabels(this.metricName + "_count", this.labels), this.count));
        }
        if (this.sum != null) {
            stringBuilder.append("%s %s\n".formatted(Metric.formatNameWithLabels(this.metricName + "_sum", this.labels), this.sum));
        }
        if (this.created != null) {
            stringBuilder.append("%s %s\n".formatted(Metric.formatNameWithLabels(this.metricName + "_created", this.labels), this.created));
        }
        if (this.quantiles != null) {
            for (Map.Entry<Double, Double> quantile : this.quantiles.entrySet()) {
                ImmutableMap quantileLabels = new ImmutableMap.Builder().putAll(this.labels).put((Object)"quantile", (Object)String.valueOf(quantile.getKey())).buildOrThrow();
                stringBuilder.append("%s %s\n".formatted(Metric.formatNameWithLabels(this.metricName, (Map<String, String>)quantileLabels), quantile.getValue()));
            }
        }
        return stringBuilder.toString();
    }
}

