/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultSetScanner;
import org.jdbi.v3.core.result.internal.ResultSetSupplier;
import org.jdbi.v3.core.statement.BaseStatement;
import org.jdbi.v3.core.statement.UnableToRetrieveMetaDataException;

public final class MetaData
extends BaseStatement<MetaData>
implements ResultBearing {
    private final MetaDataValueProvider<?> metaDataFunction;

    public MetaData(Handle handle, MetaDataValueProvider<?> metaDataFunction) {
        super(handle);
        this.metaDataFunction = metaDataFunction;
    }

    @Override
    public <R> R scanResultSet(ResultSetScanner<R> resultSetScanner) {
        return ResultBearing.of(ResultSetSupplier.closingContext(this::execute, this.getContext()), this.getContext()).scanResultSet(resultSetScanner);
    }

    public <R> R execute() {
        try {
            Connection connection = this.getHandle().getConnection();
            return (R)this.metaDataFunction.provideValue(connection.getMetaData());
        }
        catch (SQLException e) {
            throw new UnableToRetrieveMetaDataException(e, this.getContext());
        }
    }

    @FunctionalInterface
    public static interface MetaDataValueProvider<T> {
        public T provideValue(DatabaseMetaData var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface MetaDataResultSetProvider
    extends MetaDataValueProvider<ResultSet> {
        @Override
        public ResultSet provideValue(DatabaseMetaData var1) throws SQLException;
    }
}

