/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.inlined.org.antlr.v4.runtime.$CharStreams;
import org.jdbi.v3.core.internal.SqlScriptParser;
import org.jdbi.v3.core.statement.Batch;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;

public class Script
extends SqlStatement<Script> {
    private final boolean requireSemicolon;

    public Script(Handle handle, CharSequence sql) {
        super(handle, sql);
        this.requireSemicolon = handle.getConfig(SqlStatements.class).isScriptStatementsNeedSemicolon();
    }

    public Script(Handle handle, String sql) {
        super(handle, sql);
        this.requireSemicolon = handle.getConfig(SqlStatements.class).isScriptStatementsNeedSemicolon();
    }

    public int[] execute() {
        List<String> statements = this.getStatements();
        try (Batch b = this.getHandle().createBatch();){
            statements.forEach(b::add);
            int[] nArray = b.execute();
            return nArray;
        }
    }

    public void executeAsSeparateStatements() {
        for (String s : this.getStatements()) {
            this.getHandle().execute(s, new Object[0]);
        }
    }

    public List<String> getStatements() {
        TemplateEngine templateEngine = this.getConfig(SqlStatements.class).getTemplateEngine();
        return this.splitToStatements(templateEngine.render(this.getSql(), this.getContext()));
    }

    private List<String> splitToStatements(String script) {
        SqlScriptParser.ScriptTokenHandler scriptTokenHandler = new SqlScriptParser.ScriptTokenHandler(this.requireSemicolon);
        String lastStatement = new SqlScriptParser(scriptTokenHandler).parse($CharStreams.fromString(script));
        return scriptTokenHandler.addStatement(lastStatement);
    }
}

