/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.PartSupplier;
import io.trino.tpch.TpchColumn;
import io.trino.tpch.TpchColumnType;
import io.trino.tpch.TpchColumnTypes;

public enum PartSupplierColumn implements TpchColumn<PartSupplier>
{
    PART_KEY("ps_partkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(PartSupplier partSupplier) {
            return partSupplier.partKey();
        }
    }
    ,
    SUPPLIER_KEY("ps_suppkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(PartSupplier partSupplier) {
            return partSupplier.supplierKey();
        }
    }
    ,
    AVAILABLE_QUANTITY("ps_availqty", TpchColumnTypes.INTEGER){

        @Override
        public int getInteger(PartSupplier partSupplier) {
            return partSupplier.availableQuantity();
        }
    }
    ,
    SUPPLY_COST("ps_supplycost", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(PartSupplier partSupplier) {
            return partSupplier.getSupplyCost();
        }

        @Override
        public long getIdentifier(PartSupplier partSupplier) {
            return partSupplier.supplyCostInCents();
        }
    }
    ,
    COMMENT("ps_comment", TpchColumnTypes.varchar(199L)){

        @Override
        public String getString(PartSupplier partSupplier) {
            return partSupplier.comment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private PartSupplierColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(PartSupplier partSupplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getIdentifier(PartSupplier partSupplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInteger(PartSupplier partSupplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(PartSupplier partSupplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(PartSupplier entity) {
        throw new UnsupportedOperationException();
    }
}

