/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.ObjLongConsumer;

public final class LazyBlock
implements Block {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(LazyBlock.class) + SizeOf.instanceSize(LazyData.class);
    private final int positionCount;
    private final LazyData lazyData;

    public LazyBlock(int positionCount, LazyBlockLoader loader) {
        this.positionCount = positionCount;
        this.lazyData = new LazyData(positionCount, loader);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public ValueBlock getSingleValueBlock(int position) {
        return this.getBlock().getSingleValueBlock(position);
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        if (!this.isLoaded()) {
            return OptionalInt.empty();
        }
        return this.getBlock().fixedSizeInBytesPerPosition();
    }

    @Override
    public long getSizeInBytes() {
        if (!this.isLoaded()) {
            return 0L;
        }
        return this.getBlock().getSizeInBytes();
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        if (!this.isLoaded()) {
            return 0L;
        }
        return this.getBlock().getRegionSizeInBytes(position, length);
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        if (!this.isLoaded()) {
            return 0L;
        }
        return this.getBlock().getPositionsSizeInBytes(positions, selectedPositionsCount);
    }

    @Override
    public long getRetainedSizeInBytes() {
        if (!this.isLoaded()) {
            return INSTANCE_SIZE;
        }
        return (long)INSTANCE_SIZE + this.getBlock().getRetainedSizeInBytes();
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.getBlock().getEstimatedDataSizeForStats(position);
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        this.getBlock().retainedBytesForEachPart(consumer);
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public String getEncodingName() {
        return "LAZY";
    }

    @Override
    public Block copyWithAppendedNull() {
        throw new UnsupportedOperationException("LazyBlock does not support newBlockWithAppendedNull()");
    }

    @Override
    public Block getPositions(int[] positions, int offset, int length) {
        if (this.isLoaded()) {
            return this.getBlock().getPositions(positions, offset, length);
        }
        BlockUtil.checkArrayRange(positions, offset, length);
        return new LazyBlock(length, new PositionLazyBlockLoader(this.lazyData, positions, offset, length));
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        return this.getBlock().copyPositions(positions, offset, length);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        if (this.isLoaded()) {
            return this.getBlock().getRegion(positionOffset, length);
        }
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new LazyBlock(length, new RegionLazyBlockLoader(this.lazyData, positionOffset, length));
    }

    @Override
    public Block copyRegion(int position, int length) {
        return this.getBlock().copyRegion(position, length);
    }

    @Override
    public boolean isNull(int position) {
        return this.getBlock().isNull(position);
    }

    @Override
    public boolean mayHaveNull() {
        return this.getBlock().mayHaveNull();
    }

    public Block getBlock() {
        return this.lazyData.getTopLevelBlock();
    }

    @Override
    public boolean isLoaded() {
        return this.lazyData.isFullyLoaded();
    }

    @Override
    public Block getLoadedBlock() {
        return this.lazyData.getFullyLoadedBlock();
    }

    @Override
    public ValueBlock getUnderlyingValueBlock() {
        return this.getBlock().getUnderlyingValueBlock();
    }

    @Override
    public int getUnderlyingValuePosition(int position) {
        return this.getBlock().getUnderlyingValuePosition(position);
    }

    public static void listenForLoads(Block block, Consumer<Block> listener) {
        Objects.requireNonNull(block, "block is null");
        Objects.requireNonNull(listener, "listener is null");
        LazyData.addListenersRecursive(block, Collections.singletonList(listener));
    }

    private static class LazyData {
        private final int positionsCount;
        @Nullable
        private LazyBlockLoader loader;
        @Nullable
        private Block block;
        @Nullable
        private List<Consumer<Block>> listeners;

        public LazyData(int positionsCount, LazyBlockLoader loader) {
            this.positionsCount = positionsCount;
            this.loader = Objects.requireNonNull(loader, "loader is null");
        }

        public boolean isFullyLoaded() {
            return this.block != null && this.block.isLoaded();
        }

        public boolean isTopLevelBlockLoaded() {
            return this.block != null;
        }

        public Block getTopLevelBlock() {
            this.load(false);
            return this.block;
        }

        public Block getFullyLoadedBlock() {
            if (this.block != null) {
                return this.block.getLoadedBlock();
            }
            this.load(true);
            return this.block;
        }

        private void addListeners(List<Consumer<Block>> listeners) {
            if (this.isTopLevelBlockLoaded()) {
                throw new IllegalStateException("Top level block is already loaded");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Consumer<Block>>();
            }
            this.listeners.addAll(listeners);
        }

        private void load(boolean recursive) {
            if (this.loader == null) {
                return;
            }
            this.block = Objects.requireNonNull(this.loader.load(), "loader returned null");
            if (this.block.getPositionCount() != this.positionsCount) {
                throw new IllegalStateException(String.format("Loaded block positions count (%s) doesn't match lazy block positions count (%s)", this.block.getPositionCount(), this.positionsCount));
            }
            if (recursive) {
                this.block = this.block.getLoadedBlock();
            } else {
                while (this.block instanceof LazyBlock) {
                    this.block = ((LazyBlock)this.block).getBlock();
                }
            }
            this.loader = null;
            List<Consumer<Block>> listeners = this.listeners;
            this.listeners = null;
            if (listeners != null) {
                listeners.forEach(listener -> listener.accept(this.block));
                if (!recursive) {
                    LazyData.addListenersRecursive(this.block, listeners);
                }
            }
        }

        private static void addListenersRecursive(Block block, List<Consumer<Block>> listeners) {
            if (block == null) {
                return;
            }
            Block block2 = block;
            Objects.requireNonNull(block2);
            Block block3 = block2;
            int n = 0;
            block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LazyBlock.class, DictionaryBlock.class, RunLengthEncodedBlock.class, ValueBlock.class}, (Block)block3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    LazyBlock lazyBlock = (LazyBlock)block3;
                    LazyData lazyData = lazyBlock.lazyData;
                    if (lazyData.isTopLevelBlockLoaded()) {
                        LazyData.addListenersRecursive(lazyBlock.getBlock(), listeners);
                        break;
                    }
                    lazyData.addListeners(listeners);
                    break;
                }
                case 1: {
                    DictionaryBlock dictionaryBlock = (DictionaryBlock)block3;
                    LazyData.addListenersRecursive(dictionaryBlock.getDictionary(), listeners);
                    break;
                }
                case 2: {
                    RunLengthEncodedBlock runLengthEncodedBlock = (RunLengthEncodedBlock)block3;
                    LazyData.addListenersRecursive(runLengthEncodedBlock.getValue(), listeners);
                    break;
                }
                case 3: {
                    ValueBlock valueBlock;
                    ValueBlock valueBlock2 = valueBlock = (ValueBlock)block3;
                    Objects.requireNonNull(valueBlock2);
                    ValueBlock valueBlock3 = valueBlock2;
                    int n2 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayBlock.class, MapBlock.class, RowBlock.class}, (ValueBlock)valueBlock3, n2)) {
                        case 0: {
                            ArrayBlock arrayBlock = (ArrayBlock)valueBlock3;
                            LazyData.addListenersRecursive(arrayBlock.getRawElementBlock(), listeners);
                            break block0;
                        }
                        case 1: {
                            MapBlock mapBlock = (MapBlock)valueBlock3;
                            LazyData.addListenersRecursive(mapBlock.getRawKeyBlock(), listeners);
                            LazyData.addListenersRecursive(mapBlock.getRawValueBlock(), listeners);
                            break block0;
                        }
                        case 2: {
                            RowBlock rowBlock = (RowBlock)valueBlock3;
                            for (Block fieldBlock : rowBlock.getFieldBlocks()) {
                                LazyData.addListenersRecursive(fieldBlock, listeners);
                            }
                            break block0;
                        }
                    }
                }
            }
        }
    }

    private static class PositionLazyBlockLoader
    implements LazyBlockLoader {
        private final LazyData delegate;
        private final int[] positions;
        private final int offset;
        private final int length;

        public PositionLazyBlockLoader(LazyData delegate, int[] positions, int offset, int length) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.positions = Objects.requireNonNull(positions, "positions is null");
            this.offset = offset;
            this.length = length;
        }

        @Override
        public Block load() {
            return this.delegate.getTopLevelBlock().getPositions(this.positions, this.offset, this.length);
        }
    }

    private static class RegionLazyBlockLoader
    implements LazyBlockLoader {
        private final LazyData delegate;
        private final int positionOffset;
        private final int length;

        public RegionLazyBlockLoader(LazyData delegate, int positionOffset, int length) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.positionOffset = positionOffset;
            this.length = length;
        }

        @Override
        public Block load() {
            return this.delegate.getTopLevelBlock().getRegion(this.positionOffset, this.length);
        }
    }
}

