/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GroupingElement;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class GroupingSets
extends GroupingElement {
    private final Type type;
    private final List<List<Expression>> sets;

    public GroupingSets(Type type, List<List<Expression>> groupingSets) {
        this(Optional.empty(), type, groupingSets);
    }

    public GroupingSets(NodeLocation location, Type type, List<List<Expression>> sets) {
        this(Optional.of(location), type, sets);
    }

    private GroupingSets(Optional<NodeLocation> location, Type type, List<List<Expression>> sets) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(sets, "sets is null");
        Preconditions.checkArgument((!sets.isEmpty() ? 1 : 0) != 0, (Object)"grouping sets cannot be empty");
        this.sets = (List)sets.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
    }

    public Type getType() {
        return this.type;
    }

    public List<List<Expression>> getSets() {
        return this.sets;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.sets.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitGroupingSets(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingSets that = (GroupingSets)o;
        return this.type == that.type && this.sets.equals(that.sets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.sets});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("sets", this.sets).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!GroupingSets.sameClass(this, other)) {
            return false;
        }
        GroupingSets that = (GroupingSets)other;
        return Objects.equals(this.sets, that.sets) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public static enum Type {
        EXPLICIT,
        ROLLUP,
        CUBE;

    }
}

