/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonArray
extends Expression {
    private final List<JsonArrayElement> elements;
    private final boolean nullOnNull;
    private final Optional<DataType> returnedType;
    private final Optional<JsonPathParameter.JsonFormat> outputFormat;

    public JsonArray(NodeLocation location, List<JsonArrayElement> elements, boolean nullOnNull, Optional<DataType> returnedType, Optional<JsonPathParameter.JsonFormat> outputFormat) {
        super(location);
        Objects.requireNonNull(elements, "elements is null");
        Objects.requireNonNull(returnedType, "returnedType is null");
        Objects.requireNonNull(outputFormat, "outputFormat is null");
        this.elements = ImmutableList.copyOf(elements);
        this.nullOnNull = nullOnNull;
        this.returnedType = returnedType;
        this.outputFormat = outputFormat;
    }

    public List<JsonArrayElement> getElements() {
        return this.elements;
    }

    public boolean isNullOnNull() {
        return this.nullOnNull;
    }

    public Optional<DataType> getReturnedType() {
        return this.returnedType;
    }

    public Optional<JsonPathParameter.JsonFormat> getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonArray(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.elements;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArray that = (JsonArray)o;
        return Objects.equals(this.elements, that.elements) && this.nullOnNull == that.nullOnNull && Objects.equals(this.returnedType, that.returnedType) && Objects.equals(this.outputFormat, that.outputFormat);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.elements, this.nullOnNull, this.returnedType, this.outputFormat);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonArray.sameClass(this, other)) {
            return false;
        }
        JsonArray that = (JsonArray)other;
        return this.nullOnNull == that.nullOnNull && Objects.equals(this.returnedType, that.returnedType) && Objects.equals(this.outputFormat, that.outputFormat);
    }
}

