/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Relation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SampledRelation
extends Relation {
    private final Relation relation;
    private final Type type;
    private final Expression samplePercentage;

    public SampledRelation(NodeLocation location, Relation relation, Type type, Expression samplePercentage) {
        super(Optional.of(location));
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.samplePercentage = Objects.requireNonNull(samplePercentage, "samplePercentage is null");
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Type getType() {
        return this.type;
    }

    public Expression getSamplePercentage() {
        return this.samplePercentage;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSampledRelation(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.relation, (Object)this.samplePercentage);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relation", (Object)this.relation).add("type", (Object)this.type).add("samplePercentage", (Object)this.samplePercentage).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampledRelation that = (SampledRelation)o;
        return Objects.equals(this.relation, that.relation) && this.type == that.type && Objects.equals(this.samplePercentage, that.samplePercentage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.relation, this.type, this.samplePercentage});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!SampledRelation.sameClass(this, other)) {
            return false;
        }
        SampledRelation otherRelation = (SampledRelation)other;
        return this.type == otherRelation.type && Objects.equals(this.samplePercentage, otherRelation.samplePercentage);
    }

    public static enum Type {
        BERNOULLI,
        SYSTEM;

    }
}

