/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.server;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.airlift.discovery.server.Service;
import java.util.Set;

@Immutable
public class Services {
    private final String environment;
    private final Set<Service> services;

    public Services(String environment, Set<Service> services) {
        Preconditions.checkNotNull((Object)environment, (Object)"environment is null");
        Preconditions.checkNotNull(services, (Object)"services is null");
        this.environment = environment;
        this.services = ImmutableSet.copyOf(services);
    }

    @JsonProperty
    public String getEnvironment() {
        return this.environment;
    }

    @JsonProperty
    public Set<Service> getServices() {
        return this.services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Services services1 = (Services)o;
        if (!this.environment.equals(services1.environment)) {
            return false;
        }
        return this.services.equals(services1.services);
    }

    public int hashCode() {
        int result = this.environment.hashCode();
        result = 31 * result + this.services.hashCode();
        return result;
    }

    public String toString() {
        return "Services{environment='" + this.environment + "', services=" + String.valueOf(this.services) + "}";
    }
}

